/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import java.util.EventObject;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyManager;
import org.jppf.client.monitoring.topology.TopologyNode;

public class TopologyEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final TopologyDriver driverData;
    private final TopologyNode nodeData;
    private final UpdateType updateType;

    public TopologyEvent(TopologyManager source, TopologyDriver driverData, TopologyNode nodeData, UpdateType updateType) {
        super(source);
        this.driverData = driverData;
        this.nodeData = nodeData;
        this.updateType = updateType;
    }

    public TopologyDriver getDriver() {
        return this.driverData;
    }

    public TopologyNode getNodeOrPeer() {
        return this.nodeData;
    }

    public TopologyManager getTopologyManager() {
        return (TopologyManager)this.getSource();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("source=").append(this.getTopologyManager());
        sb.append(", driver=").append(this.getDriver());
        sb.append(", node/peer=").append(this.getNodeOrPeer());
        sb.append(']');
        return sb.toString();
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public static enum UpdateType {
        TOPOLOGY,
        JVM_HEALTH,
        NODE_STATE;

    }

    static enum Type {
        DRIVER_ADDED,
        DRIVER_REMOVED,
        DRIVER_UPDATED,
        NODE_ADDED,
        NODE_REMOVED,
        NODE_UPDATED;

    }
}

