/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jppf.client.monitoring.AbstractRefreshHandler;
import org.jppf.client.monitoring.topology.AbstractTopologyComponent;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyEvent;
import org.jppf.client.monitoring.topology.TopologyManager;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.client.monitoring.topology.TopologyNodeStatus;
import org.jppf.client.monitoring.topology.TopologyPeer;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFNodeState;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.NodeSelector;
import org.jppf.management.UuidSelector;
import org.jppf.management.forwarding.NodeForwardingMBean;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.InvocationResult;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ResultsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeRefreshHandler
extends AbstractRefreshHandler {
    private static Logger log = LoggerFactory.getLogger(NodeRefreshHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final TopologyManager manager;
    private final boolean loadSystemInfo;

    NodeRefreshHandler(TopologyManager manager, long period) {
        this(manager, period, false);
    }

    NodeRefreshHandler(TopologyManager manager, long period, boolean loadSystemInfo) {
        super("JPPF Topology Update Timer", period);
        this.manager = manager;
        this.loadSystemInfo = loadSystemInfo;
        this.startRefreshTimer();
    }

    @Override
    protected synchronized void performRefresh() {
        for (TopologyDriver driver : this.manager.getDrivers()) {
            this.refreshNodes(driver);
            if (driver.getChildCount() <= 0) continue;
            this.refreshNodeStates(driver);
        }
    }

    private void refreshNodes(TopologyDriver driver) {
        HashSet<String> knownUuids = new HashSet<String>();
        for (AbstractTopologyComponent child : driver.getChildren()) {
            knownUuids.add(child.getUuid());
        }
        JMXDriverConnectionWrapper jmx = driver.getJmx();
        if (jmx == null || !jmx.isConnected()) {
            return;
        }
        Collection nodesInfo = null;
        try {
            nodesInfo = jmx.nodesInformation(this.manager.getNodeFilter(), true);
        }
        catch (Exception e) {
            if (debugEnabled) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            return;
        }
        HashMap<String, Object> actualMap = new HashMap<String, Object>();
        if (nodesInfo != null) {
            for (Object info : nodesInfo) {
                if (info.getPort() < 0) continue;
                actualMap.put(info.getUuid(), info);
            }
        }
        ArrayList<String> nodesToProcess = new ArrayList<String>(knownUuids.size());
        for (String uuid : knownUuids) {
            if (actualMap.containsKey(uuid)) continue;
            nodesToProcess.add(uuid);
        }
        for (String uuid : nodesToProcess) {
            TopologyNode node = (TopologyNode)driver.getChild(uuid);
            if (debugEnabled) {
                log.debug("removing node " + node);
            }
            if (node == null) continue;
            this.manager.nodeRemoved(driver, node);
        }
        ArrayList<String> addedNodes = new ArrayList<String>();
        for (Map.Entry entry : actualMap.entrySet()) {
            TopologyNode node;
            String uuid = (String)entry.getKey();
            JPPFManagementInfo info = (JPPFManagementInfo)entry.getValue();
            if (!knownUuids.contains(uuid)) {
                if (debugEnabled) {
                    log.debug("adding node " + info);
                }
                node = null;
                node = info.isPeer() ? new TopologyPeer(info) : new TopologyNode(info);
                this.manager.nodeAdded(driver, node);
                if (info.isNode()) {
                    addedNodes.add(uuid);
                }
            } else {
                node = this.manager.getNodeOrPeer(uuid);
                if (node != null && info.isActive() != node.getManagementInfo().isActive()) {
                    node.getManagementInfo().setIsActive(((JPPFManagementInfo)entry.getValue()).isActive());
                    this.manager.nodeUpdated(driver, node, TopologyEvent.UpdateType.NODE_STATE);
                }
            }
            if (addedNodes.isEmpty() || !this.loadSystemInfo) continue;
            try {
                ResultsMap map = jmx.getForwarder().systemInformation((NodeSelector)new UuidSelector(addedNodes));
                for (Map.Entry ent : map.entrySet()) {
                    TopologyNode node2;
                    JPPFSystemInformation o = (JPPFSystemInformation)((InvocationResult)ent.getValue()).result();
                    if (o == null || (node2 = this.manager.getNode((String)ent.getKey())) == null) continue;
                    node2.getManagementInfo().setSystemInfo(o);
                }
            }
            catch (Exception e) {
                if (!debugEnabled) continue;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void refreshNodeStates(TopologyDriver driver) {
        NodeForwardingMBean forwarder = driver.getForwarder();
        if (forwarder == null) {
            return;
        }
        List children = driver.getChildren();
        HashMap<String, TopologyNode> uuidMap = new HashMap<String, TopologyNode>();
        for (AbstractTopologyComponent child : children) {
            if (!child.isNode()) continue;
            uuidMap.put(child.getUuid(), (TopologyNode)child);
        }
        ResultsMap result = null;
        try {
            result = forwarder.state((NodeSelector)new UuidSelector(uuidMap.keySet()));
        }
        catch (Exception e) {
            log.error("error getting node states for driver " + driver.getUuid(), (Throwable)e);
        }
        if (result == null) {
            return;
        }
        HashSet<TopologyNode> changedNodes = new HashSet<TopologyNode>();
        for (Map.Entry entry : result.entrySet()) {
            JPPFNodeState oldState;
            TopologyNode node = (TopologyNode)uuidMap.get(entry.getKey());
            if (node == null) continue;
            if (((InvocationResult)entry.getValue()).isException()) {
                node.setStatus(TopologyNodeStatus.DOWN);
                if (!debugEnabled) continue;
                log.debug("exception raised for node " + (String)entry.getKey() + " : " + ExceptionUtils.getMessage((Throwable)((InvocationResult)entry.getValue()).exception()));
                continue;
            }
            if (((InvocationResult)entry.getValue()).result() == null || (oldState = (JPPFNodeState)((InvocationResult)entry.getValue()).result()).equals((Object)node.getNodeState())) continue;
            changedNodes.add(node);
            node.refreshNodeState(oldState);
        }
        NodeRefreshHandler.refreshProvisioningStates(driver, forwarder, changedNodes);
        for (TopologyNode node : changedNodes) {
            this.manager.nodeUpdated(driver, node, TopologyEvent.UpdateType.NODE_STATE);
        }
    }

    private static void refreshProvisioningStates(TopologyDriver driver, NodeForwardingMBean forwarder, Set<TopologyNode> changedNodes) {
        ResultsMap result;
        HashMap<String, TopologyNode> uuidMap;
        block6: {
            uuidMap = new HashMap<String, TopologyNode>();
            for (AbstractTopologyComponent child : driver.getChildren()) {
                TopologyNode node;
                if (!child.isNode() || !(node = (TopologyNode)child).getManagementInfo().isMasterNode()) continue;
                uuidMap.put(child.getUuid(), (TopologyNode)child);
            }
            result = null;
            try {
                result = forwarder.getNbSlaves((NodeSelector)new UuidSelector(uuidMap.keySet()));
            }
            catch (Exception e) {
                if (!debugEnabled) break block6;
                log.debug("error getting number of slaves for driver " + driver.getUuid(), (Throwable)e);
            }
        }
        if (result == null) {
            return;
        }
        for (Map.Entry entry : result.entrySet()) {
            TopologyNode node = (TopologyNode)uuidMap.get(entry.getKey());
            if (node == null) continue;
            if (((InvocationResult)entry.getValue()).isException()) {
                node.setStatus(TopologyNodeStatus.DOWN);
                if (!debugEnabled) continue;
                log.debug("exception raised for node " + (String)entry.getKey() + " : " + ExceptionUtils.getMessage((Throwable)((InvocationResult)entry.getValue()).exception()));
                continue;
            }
            if (((InvocationResult)entry.getValue()).result() == null) continue;
            node.setStatus(TopologyNodeStatus.UP);
            int n = (Integer)((InvocationResult)entry.getValue()).result();
            if (n == node.getNbSlaveNodes()) continue;
            changedNodes.add(node);
            node.setNbSlaveNodes(n);
        }
    }
}

