/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jppf.client.monitoring.AbstractRefreshHandler;
import org.jppf.client.monitoring.topology.AbstractTopologyComponent;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyEvent;
import org.jppf.client.monitoring.topology.TopologyManager;
import org.jppf.client.monitoring.topology.TopologyNode;
import org.jppf.client.monitoring.topology.TopologyNodeStatus;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.NodeSelector;
import org.jppf.management.UuidSelector;
import org.jppf.management.diagnostics.HealthSnapshot;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.InvocationResult;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.ResultsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JVMHealthRefreshHandler
extends AbstractRefreshHandler {
    private static Logger log = LoggerFactory.getLogger(JVMHealthRefreshHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final TopologyManager manager;

    JVMHealthRefreshHandler(TopologyManager manager, long period) {
        super("JVM Health Update Timer", period);
        this.manager = manager;
        this.startRefreshTimer();
    }

    @Override
    protected synchronized void performRefresh() {
        for (TopologyDriver driver : this.manager.getDrivers()) {
            ResultsMap result;
            HashMap<String, TopologyNode> uuidMap;
            block11: {
                block10: {
                    JMXDriverConnectionWrapper jmx;
                    if (driver.getDiagnostics() == null || (jmx = driver.getJmx()) == null || !jmx.isConnected()) continue;
                    try {
                        HealthSnapshot health = driver.getDiagnostics().healthSnapshot();
                        if (log.isTraceEnabled()) {
                            log.trace("got driver health snapshot: " + health);
                        }
                        if (health != null && !health.equals(driver.getHealthSnapshot())) {
                            driver.refreshHealthSnapshot(health);
                            this.manager.driverUpdated(driver, TopologyEvent.UpdateType.JVM_HEALTH);
                        }
                    }
                    catch (Exception e) {
                        if (!debugEnabled) break block10;
                        log.debug("error getting health snapshot for driver {} : {}" + driver, (Object)ExceptionUtils.getMessage((Throwable)e));
                    }
                }
                if (driver.getChildCount() <= 0 || driver.getForwarder() == null) continue;
                uuidMap = new HashMap<String, TopologyNode>();
                for (AbstractTopologyComponent comp : driver.getChildren()) {
                    if (comp.isPeer()) continue;
                    TopologyNode node = (TopologyNode)comp;
                    uuidMap.put(node.getUuid(), node);
                }
                result = null;
                try {
                    result = driver.getForwarder().healthSnapshot((NodeSelector)new UuidSelector(new HashSet(uuidMap.keySet())));
                }
                catch (Exception e) {
                    if (!debugEnabled) break block11;
                    log.debug("error getting nodes health for driver {} : {}" + driver, (Object)ExceptionUtils.getMessage((Throwable)e));
                }
            }
            if (result == null) continue;
            for (Map.Entry entry : result.entrySet()) {
                HealthSnapshot health;
                TopologyNode node = (TopologyNode)uuidMap.get(entry.getKey());
                if (node == null) continue;
                if (((InvocationResult)entry.getValue()).isException()) {
                    node.setStatus(TopologyNodeStatus.DOWN);
                    if (!debugEnabled) continue;
                    log.debug("exception raised for node " + (String)entry.getKey() + " : " + ExceptionUtils.getMessage((Throwable)((InvocationResult)entry.getValue()).exception()));
                    continue;
                }
                if (((InvocationResult)entry.getValue()).result() == null || (health = (HealthSnapshot)((InvocationResult)entry.getValue()).result()).equals(node.getHealthSnapshot())) continue;
                node.refreshHealthSnapshot(health);
                this.manager.nodeUpdated(driver, node, TopologyEvent.UpdateType.JVM_HEALTH);
                if (!log.isTraceEnabled()) continue;
                log.trace("got new node health snapshot: " + health);
            }
        }
    }
}

