/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jppf.client.monitoring.jobs.DeferredJobNotificationsHandler;
import org.jppf.client.monitoring.jobs.ImmediateJobNotificationsHandler;
import org.jppf.client.monitoring.jobs.Job;
import org.jppf.client.monitoring.jobs.JobDispatch;
import org.jppf.client.monitoring.jobs.JobDriver;
import org.jppf.client.monitoring.jobs.JobMonitorUpdateMode;
import org.jppf.client.monitoring.jobs.JobMonitoringEvent;
import org.jppf.client.monitoring.jobs.JobMonitoringHandler;
import org.jppf.client.monitoring.jobs.JobMonitoringListener;
import org.jppf.client.monitoring.jobs.JobPollingHandler;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyEvent;
import org.jppf.client.monitoring.topology.TopologyListenerAdapter;
import org.jppf.client.monitoring.topology.TopologyManager;
import org.jppf.job.JobInformation;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMonitor
extends TopologyListenerAdapter
implements JobMonitoringHandler {
    private static Logger log = LoggerFactory.getLogger(JobMonitor.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final TopologyManager topologyManager;
    private final Map<String, JobDriver> driverMap = new HashMap<String, JobDriver>();
    private final CollectionMap<String, JobDriver> jobDriverMap = new SetHashMap();
    private final Object lock = new Object();
    private final List<JobMonitoringListener> listeners = new CopyOnWriteArrayList<JobMonitoringListener>();
    final AutoCloseable refreshHandler;

    public JobMonitor(TopologyManager topologyManager, JobMonitoringListener ... listeners) {
        this(JobMonitorUpdateMode.IMMEDIATE_NOTIFICATIONS, 0L, topologyManager, listeners);
    }

    public JobMonitor(JobMonitorUpdateMode updateMode, long period, TopologyManager topologyManager, JobMonitoringListener ... listeners) {
        if (debugEnabled) {
            log.debug("initializing job monitor in {} mode with period = {}", (Object)updateMode, (Object)period);
        }
        this.topologyManager = topologyManager;
        if (listeners != null) {
            for (JobMonitoringListener listener : listeners) {
                this.addJobMonitoringListener(listener);
            }
        }
        for (TopologyDriver driver : topologyManager.getDrivers()) {
            this.driverAdded(new JobDriver(driver));
        }
        topologyManager.addTopologyListener(this);
        switch (updateMode) {
            case POLLING: {
                this.refreshHandler = new JobPollingHandler(this, "JobRefreshHandler", period);
                break;
            }
            case DEFERRED_NOTIFICATIONS: {
                this.refreshHandler = new DeferredJobNotificationsHandler(this, "JobRefreshHandler", period);
                break;
            }
            default: {
                this.refreshHandler = new ImmediateJobNotificationsHandler(this);
            }
        }
    }

    public TopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobDriver getJobDriver(String driverUuid) {
        Map<String, JobDriver> map = this.driverMap;
        synchronized (map) {
            return this.driverMap.get(driverUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobDriver> getJobDrivers() {
        Map<String, JobDriver> map = this.driverMap;
        synchronized (map) {
            return new ArrayList<JobDriver>(this.driverMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobDriver> getDriversForJob(String jobUuid) {
        ArrayList<JobDriver> result = new ArrayList<JobDriver>();
        Object object = this.lock;
        synchronized (object) {
            Collection drivers = this.jobDriverMap.getValues((Object)jobUuid);
            if (drivers != null) {
                result.addAll(drivers);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobDispatch> getAllJobDispatches(String jobUuid) {
        ArrayList<JobDispatch> result = new ArrayList<JobDispatch>();
        Object object = this.lock;
        synchronized (object) {
            Collection drivers = this.jobDriverMap.getValues((Object)jobUuid);
            if (drivers != null) {
                for (JobDriver driver : drivers) {
                    Job job = driver.getJob(jobUuid);
                    if (job == null) continue;
                    result.addAll(job.getJobDispatches());
                }
            }
        }
        return result;
    }

    public void addJobMonitoringListener(JobMonitoringListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeJobMonitoringListener(JobMonitoringListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void driverAdded(TopologyEvent event) {
        this.driverAdded(new JobDriver(event.getDriver()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driverAdded(JobDriver driver) {
        if (debugEnabled) {
            log.debug("driver {} added", (Object)driver.getDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.driverMap.get(driver.getUuid()) != null) {
                return;
            }
            this.driverMap.put(driver.getUuid(), driver);
        }
        this.dispatchEvent(JobMonitoringEvent.Type.DRIVER_ADDED, new JobMonitoringEvent(this, driver, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void driverRemoved(TopologyEvent event) {
        String uuid = event.getDriver().getUuid();
        JobDriver driver = null;
        Object object = this.lock;
        synchronized (object) {
            driver = this.driverMap.get(uuid);
        }
        if (driver != null) {
            this.driverRemoved(driver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void driverRemoved(JobDriver driver) {
        if (debugEnabled) {
            log.debug("driver {} removed", (Object)driver.getDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.driverMap.remove(driver.getUuid());
        }
        this.dispatchEvent(JobMonitoringEvent.Type.DRIVER_REMOVED, new JobMonitoringEvent(this, driver, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobAdded(JobDriver driver, Job job) {
        if (debugEnabled) {
            log.debug("job '{}' added to driver {}", (Object)job.getDisplayName(), (Object)driver.getDisplayName());
        }
        driver.add(job);
        Object object = this.lock;
        synchronized (object) {
            this.jobDriverMap.putValue((Object)job.getUuid(), (Object)driver);
        }
        this.dispatchEvent(JobMonitoringEvent.Type.JOB_ADDED, new JobMonitoringEvent(this, driver, job, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jobRemoved(JobDriver driver, Job job) {
        if (debugEnabled) {
            log.debug("job '{}' removed from driver {}", (Object)job.getDisplayName(), (Object)driver.getDisplayName());
        }
        if (job != null) {
            driver.remove(job);
            Object object = this.lock;
            synchronized (object) {
                this.jobDriverMap.removeValue((Object)job.getUuid(), (Object)driver);
            }
            this.dispatchEvent(JobMonitoringEvent.Type.JOB_REMOVED, new JobMonitoringEvent(this, driver, job, null));
        }
    }

    void jobUpdated(JobDriver driver, Job job) {
        if (debugEnabled) {
            log.debug("job '{}' updated in driver {}", (Object)job.getDisplayName(), (Object)driver.getDisplayName());
        }
        this.dispatchEvent(JobMonitoringEvent.Type.JOB_UPDATED, new JobMonitoringEvent(this, driver, job, null));
    }

    void dispatchAdded(JobDriver driver, Job job, JobDispatch dispatch) {
        if (debugEnabled) {
            log.debug("adding dispatch {} to job {}", (Object)dispatch, (Object)job);
        }
        if (job != null) {
            job.add(dispatch);
            this.dispatchEvent(JobMonitoringEvent.Type.DISPATCH_ADDED, new JobMonitoringEvent(this, driver, job, dispatch));
        }
    }

    void dispatchRemoved(JobDriver driver, Job job, JobDispatch dispatch) {
        if (debugEnabled) {
            log.debug("removing dispatch {} from job '{}'", (Object)(dispatch == null ? "null" : dispatch.getDisplayName()), (Object)job.getDisplayName());
        }
        if (dispatch != null) {
            job.remove(dispatch);
            this.dispatchEvent(JobMonitoringEvent.Type.DISPATCH_REMOVED, new JobMonitoringEvent(this, driver, job, dispatch));
        }
    }

    void dispatchEvent(JobMonitoringEvent.Type type, JobMonitoringEvent event) {
        try {
            switch (type) {
                case DRIVER_ADDED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.driverAdded(event);
                    }
                    break;
                }
                case DRIVER_REMOVED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.driverRemoved(event);
                    }
                    break;
                }
                case JOB_ADDED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.jobAdded(event);
                    }
                    break;
                }
                case JOB_REMOVED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.jobRemoved(event);
                    }
                    break;
                }
                case JOB_UPDATED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.jobUpdated(event);
                    }
                    break;
                }
                case DISPATCH_ADDED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.jobDispatchAdded(event);
                    }
                    break;
                }
                case DISPATCH_REMOVED: {
                    for (JobMonitoringListener listener : this.listeners) {
                        listener.jobDispatchRemoved(event);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("error dispatching event of type {}, event={}, exception: {}", new Object[]{type, event, ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }

    boolean isJobUpdated(JobInformation oldJob, JobInformation newJob) {
        return oldJob.getTaskCount() != newJob.getTaskCount() || oldJob.getMaxNodes() != newJob.getMaxNodes() || oldJob.getPriority() != newJob.getPriority() || oldJob.isSuspended() ^ newJob.isSuspended() || oldJob.isPending() ^ newJob.isPending();
    }

    @Override
    public void close() {
        try {
            this.listeners.clear();
            this.refreshHandler.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

