/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.monitoring.jobs.AbstractJobComponent;
import org.jppf.client.monitoring.jobs.Job;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.server.job.management.DriverJobManagementMBean;

public class JobDriver
extends AbstractJobComponent {
    private static final long serialVersionUID = 1L;
    private final transient TopologyDriver driver;

    JobDriver(TopologyDriver driver) {
        super(driver.getUuid());
        this.driver = driver;
    }

    public DriverJobManagementMBean getJobManager() {
        return this.driver.getJobManager();
    }

    public TopologyDriver getTopologyDriver() {
        return this.driver;
    }

    public Job getJob(String jobUuid) {
        return (Job)this.getChild(jobUuid);
    }

    public List<Job> getJobs() {
        ArrayList<Job> list = new ArrayList<Job>(this.getChildCount());
        for (AbstractJobComponent comp : this.getChildren()) {
            list.add((Job)comp);
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("uuid=").append(this.uuid);
        sb.append(", driver=").append(this.driver);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getDisplayName() {
        return this.driver != null ? this.driver.getDisplayName() : "" + this.uuid;
    }
}

