/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring.jobs;

import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.jppf.client.monitoring.jobs.JobMonitor;
import org.jppf.client.monitoring.jobs.JobMonitoringHandler;
import org.jppf.client.monitoring.topology.TopologyDriver;
import org.jppf.client.monitoring.topology.TopologyEvent;
import org.jppf.client.monitoring.topology.TopologyListenerAdapter;
import org.jppf.job.JobNotification;
import org.jppf.server.job.management.DriverJobManagementMBean;
import org.jppf.utils.concurrent.QueueHandler;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.jppf.utils.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractJobNotificationsHandler
implements NotificationListener,
JobMonitoringHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractJobNotificationsHandler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final int DEFAULT_MAX_NOTIFICATIONS = 5000;
    final JobMonitor monitor;
    final QueueHandler<JobNotification> notificationsQueue;
    final Map<String, JmxInitializer> initializerMap = new HashMap<String, JmxInitializer>();
    final DriverListener driverListener;

    AbstractJobNotificationsHandler(JobMonitor monitor) {
        if (debugEnabled) {
            log.debug("initializing {} with {}", (Object)this.getClass().getSimpleName(), (Object)monitor);
        }
        this.monitor = monitor;
        this.driverListener = new DriverListener();
        monitor.getTopologyManager().addTopologyListener(this.driverListener);
        int capacity = monitor.getTopologyManager().getJPPFClient().getConfig().getInt("jppf.job.monitor.max.notifications", 5000);
        int cap = capacity <= 0 ? 5000 : capacity;
        this.notificationsQueue = QueueHandler.builder().named("JobNotificationsHandler").withCapacity(cap).handlingElementsAs(this::handleNotificationAsync).handlingPeakSizeAs(n -> {
            if (debugEnabled && n >= cap) {
                log.debug("maximum peak job notifications: {}", (Object)n);
            }
        }).usingSingleDequuerThread().build();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (log.isTraceEnabled()) {
            log.trace("got jmx notification: {}", (Object)notification);
        }
        try {
            this.notificationsQueue.put((Object)((JobNotification)notification));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    abstract void handleNotificationAsync(JobNotification var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.monitor.getTopologyManager().removeTopologyListener(this.driverListener);
        this.notificationsQueue.close();
        Map<String, JmxInitializer> map = this.initializerMap;
        synchronized (map) {
            this.initializerMap.clear();
        }
    }

    private class JmxInitializer
    extends ThreadSynchronization
    implements Runnable {
        final TopologyDriver driver;

        JmxInitializer(TopologyDriver driver) {
            this.driver = driver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (debugEnabled) {
                log.debug("starting jmx intializer for " + this.driver);
            }
            boolean done = false;
            while (!done && !this.isStopped()) {
                try {
                    DriverJobManagementMBean mbean = this.driver.getJobManager();
                    if (mbean != null) {
                        done = true;
                        mbean.addNotificationListener((NotificationListener)AbstractJobNotificationsHandler.this, null, null);
                        if (debugEnabled) {
                            log.debug("registered jmx listener for " + this.driver);
                        }
                        Map<String, JmxInitializer> map = AbstractJobNotificationsHandler.this.initializerMap;
                        synchronized (map) {
                            AbstractJobNotificationsHandler.this.initializerMap.remove(this.driver.getUuid());
                            continue;
                        }
                    }
                    this.goToSleep(10L);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class DriverListener
    extends TopologyListenerAdapter {
        private DriverListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void driverAdded(TopologyEvent event) {
            TopologyDriver driver = event.getDriver();
            JmxInitializer jinit = new JmxInitializer(driver);
            Map<String, JmxInitializer> map = AbstractJobNotificationsHandler.this.initializerMap;
            synchronized (map) {
                AbstractJobNotificationsHandler.this.initializerMap.put(driver.getUuid(), jinit);
            }
            ThreadUtils.startDaemonThread((Runnable)jinit, (String)driver.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void driverRemoved(TopologyEvent event) {
            String uuid = event.getDriver().getUuid();
            if (uuid != null) {
                JmxInitializer jinit = null;
                Map<String, JmxInitializer> map = AbstractJobNotificationsHandler.this.initializerMap;
                synchronized (map) {
                    jinit = AbstractJobNotificationsHandler.this.initializerMap.remove(uuid);
                }
                if (jinit != null) {
                    jinit.setStopped(true);
                }
            }
        }
    }
}

