/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.monitoring;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractRefreshHandler {
    private Timer refreshTimer = null;
    private final long refreshInterval;
    private AtomicBoolean refreshing = new AtomicBoolean(false);
    private AtomicBoolean suspended = new AtomicBoolean(false);
    private final String name;

    public AbstractRefreshHandler(String name, long refreshInterval) {
        this.refreshInterval = refreshInterval;
        this.name = name;
    }

    public void refresh() {
        if (this.refreshing.compareAndSet(false, true) && !this.suspended.get()) {
            try {
                this.performRefresh();
            }
            finally {
                this.refreshing.set(false);
            }
        }
    }

    protected abstract void performRefresh();

    public void stopRefreshTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
    }

    public void startRefreshTimer() {
        if (this.refreshTimer != null) {
            return;
        }
        if (this.refreshInterval <= 0L) {
            return;
        }
        this.refreshTimer = new Timer(this.name == null ? "RefreshHandler Timer" : this.name, true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!AbstractRefreshHandler.this.suspended.get()) {
                    AbstractRefreshHandler.this.refresh();
                }
            }
        };
        this.refreshTimer.schedule(task, 1000L, this.refreshInterval);
    }

    public boolean isSuspended() {
        return this.suspended.get();
    }

    public void setSuspended(boolean suspended) {
        this.suspended.set(suspended);
    }
}

