/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.debug;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.debug.DebugMBean;
import org.jppf.management.ObjectNameCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug
implements DebugMBean {
    private static final Logger log = LoggerFactory.getLogger(Debug.class);
    private final JPPFClient client;
    private final Map<String, String> parameters = new TreeMap<String, String>();

    public Debug(JPPFClient client) {
        this.client = client;
    }

    @Override
    public String allConnections() {
        List<JPPFConnectionPool> all = this.client.getConnectionPools();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (JPPFConnectionPool pool : all) {
            for (JPPFClientConnection c : pool.getConnections()) {
                if (count > 0) {
                    sb.append('\n');
                }
                sb.append(c.toString());
                ++count;
            }
        }
        return sb.toString();
    }

    public static void register(JPPFClient client) {
        try {
            Debug debug = new Debug(client);
            StandardMBean mbean = new StandardMBean(debug, DebugMBean.class);
            ObjectName name = ObjectNameCache.getObjectName((String)("org.jppf:name=debug,type=client,uuid=" + client.getUuid()));
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.registerMBean(mbean, name);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void unregister(JPPFClient client) {
        try {
            ObjectName name = ObjectNameCache.getObjectName((String)("org.jppf:name=debug,type=client,uuid=" + client.getUuid()));
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    @Override
    public void removeParameter(String key) {
        this.parameters.remove(key);
    }

    @Override
    public String allParameters() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            if (count++ > 0) {
                sb.append('\n');
            }
            sb.append(param.getKey()).append(" = ").append(param.getValue());
        }
        return sb.toString();
    }
}

