/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jppf.client.JPPFJob;
import org.jppf.client.concurrent.AbstractJPPFFuture;
import org.jppf.node.protocol.Task;
import org.jppf.utils.DateTimeUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFTaskFuture<V>
extends AbstractJPPFFuture<V> {
    private static Logger log = LoggerFactory.getLogger(JPPFTaskFuture.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFJob job;
    private final int position;

    public JPPFTaskFuture(JPPFJob job, int position) {
        this.job = job;
        this.position = position;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        V v;
        block2: {
            v = null;
            try {
                v = this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                if (!debugEnabled) break block2;
                log.debug("wait timed out, but it shouldn't have", (Throwable)e);
            }
        }
        return v;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long millis = TimeUnit.MILLISECONDS.equals((Object)unit) ? timeout : DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit);
        this.getResult(millis);
        if (this.timedout.get()) {
            throw new TimeoutException("wait timed out");
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return (V)this.result;
    }

    void getResult(long timeout) throws TimeoutException {
        if (!this.isDone()) {
            Task<?> task = null;
            task = timeout > 0L ? this.job.getResults().waitForTask(this.position, timeout) : this.job.getResults().getResultTask(this.position);
            this.setDone();
            if (task == null) {
                this.setCancelled();
                this.timedout.set(timeout > 0L);
                if (timeout > 0L) {
                    throw new TimeoutException();
                }
            } else {
                this.result = task.getResult();
                this.throwable = task.getThrowable();
            }
        }
    }

    void setDone() {
        this.done.compareAndSet(false, true);
    }

    void setCancelled() {
        this.cancelled.set(true);
    }

    public Task<?> getTask() {
        Task<?> task = this.job.getResults().getResultTask(this.position);
        return task != null ? task : this.job.getJobTasks().get(this.position);
    }

    int getPosition() {
        return this.position;
    }

    public JPPFJob getJob() {
        return this.job;
    }
}

