/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import java.text.ParseException;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.queue.JobExpirationAction;
import org.jppf.client.balancer.queue.JobScheduleAction;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.scheduling.JPPFScheduleHandler;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduleManager {
    private static final Logger log = LoggerFactory.getLogger(ScheduleManager.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final JPPFScheduleHandler jobStartHandler = new JPPFScheduleHandler("Job Schedule Handler");
    private final JPPFScheduleHandler jobExpirationHandler = new JPPFScheduleHandler("Job Expiration Handler");

    ScheduleManager() {
    }

    void handleStartJobSchedule(ClientJob clientJob) {
        String uuid = clientJob.getUuid();
        if (this.jobStartHandler.hasAction(uuid)) {
            return;
        }
        JPPFSchedule schedule = clientJob.getClientSLA().getJobSchedule();
        if (schedule != null) {
            clientJob.setPending(true);
            String name = clientJob.getName();
            if (debugEnabled) {
                log.debug("found start " + schedule + " for jobId = " + name);
            }
            try {
                long dt = clientJob.getJobReceivedTime();
                this.jobStartHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobScheduleAction(clientJob), dt);
                clientJob.addOnDone(() -> this.jobStartHandler.cancelAction((Object)uuid));
            }
            catch (ParseException e) {
                clientJob.setPending(false);
                log.error("Unparseable start date for job '{}' : date = {}, date format = {}\n{}", new Object[]{name, schedule.getDate(), schedule.getFormat(), ExceptionUtils.getStackTrace((Throwable)e)});
            }
        } else {
            clientJob.setPending(false);
        }
    }

    void handleExpirationJobSchedule(ClientJob clientJob) {
        String uuid = clientJob.getUuid();
        if (this.jobExpirationHandler.hasAction(uuid)) {
            return;
        }
        JPPFSchedule schedule = clientJob.getClientSLA().getJobExpirationSchedule();
        if (schedule != null) {
            String name = clientJob.getName();
            if (debugEnabled) {
                log.debug("found expiration " + schedule + " for jobId = " + name);
            }
            long dt = clientJob.getJobReceivedTime();
            try {
                this.jobExpirationHandler.scheduleAction((Object)uuid, schedule, (Runnable)new JobExpirationAction(clientJob), dt);
                clientJob.addOnDone(() -> this.jobExpirationHandler.cancelAction((Object)uuid));
            }
            catch (ParseException e) {
                log.error("Unparseable expiration date for job '{}' : date = {}, date format = {}\n{}", new Object[]{name, schedule.getDate(), schedule.getFormat(), ExceptionUtils.getStackTrace((Throwable)e)});
            }
        }
    }

    void clearSchedules(String jobUuid) {
        this.jobStartHandler.cancelAction((Object)jobUuid);
        this.jobExpirationHandler.cancelAction((Object)jobUuid);
    }

    void close() {
        this.jobStartHandler.clear(true);
        this.jobExpirationHandler.clear(true);
    }
}

