/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer.queue;

import org.jppf.client.balancer.ClientJob;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobExpirationAction
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JobExpirationAction.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final ClientJob clientJob;

    public JobExpirationAction(ClientJob clientJob) {
        if (clientJob == null) {
            throw new IllegalArgumentException("bundleWrapper is null");
        }
        this.clientJob = clientJob;
    }

    @Override
    public void run() {
        String jobId = this.clientJob.getName();
        try {
            if (debugEnabled) {
                log.debug("job '" + jobId + "' is expiring");
            }
            this.clientJob.jobExpired();
        }
        catch (Exception e) {
            log.error("Error while cancelling job id = " + jobId, (Throwable)e);
        }
    }
}

