/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobResults;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientJob;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFTaskBundle;
import org.jppf.node.protocol.PositionalElement;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.graph.TaskGraph;
import org.jppf.node.protocol.graph.TaskGraphInfo;
import org.jppf.utils.collections.ArrayListHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTaskBundle
extends JPPFTaskBundle {
    private static final Logger log = LoggerFactory.getLogger(ClientTaskBundle.class);
    private static final long serialVersionUID = 1L;
    private static final AtomicLong instanceCount = new AtomicLong(0L);
    private final long bundleId = instanceCount.incrementAndGet();
    private final ClientJob job;
    private transient DataProvider dataProvider;
    private transient List<Task<?>> tasks;
    private transient String broadcastUUID;
    private boolean requeued;
    private boolean cancelled;
    private TaskGraphInfo graphInfo;

    public ClientTaskBundle(ClientJob job, Collection<Task<?>> tasks) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        this.job = job;
        this.setSLA(job.getSLA());
        this.setMetadata(job.getJob().getMetadata());
        this.tasks = new ArrayList(tasks);
        this.setName(job.getJob().getName());
        this.setUuid(job.getUuid());
        this.setTaskCount(this.tasks.size());
        this.resolveDependencies();
    }

    public JPPFJob getJob() {
        return this.job.getJob();
    }

    public ClientJob getClientJob() {
        return this.job;
    }

    public DataProvider getDataProviderL() {
        return this.dataProvider;
    }

    public void setDataProviderL(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public List<Task<?>> getTasksL() {
        return this.tasks;
    }

    public ClientTaskBundle copy() {
        throw new UnsupportedOperationException();
    }

    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    public void setBroadcastUUID(String broadcastUUID) {
        this.broadcastUUID = broadcastUUID;
    }

    public void jobDispatched(ChannelWrapper channel) {
        this.job.jobDispatched(this, channel);
    }

    public void resultsReceived(List<Task<?>> results) {
        this.job.resultsReceived(this, results);
    }

    public void resultsReceived(Throwable throwable) {
        this.job.resultsReceived(this, throwable);
    }

    public void taskCompleted(Exception exception) {
        this.job.taskCompleted(this, exception);
    }

    public synchronized void resubmit() {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.requeued = true;
    }

    public synchronized boolean isRequeued() {
        return this.requeued;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append('[');
        sb.append("bundleId=").append(this.bundleId);
        sb.append(", name=").append(this.getName());
        sb.append(", jobUuid=").append(this.getUuid());
        sb.append(", initialTaskCount=").append(this.getInitialTaskCount());
        sb.append(", taskCount=").append(this.getTaskCount());
        sb.append(", requeue=").append(this.isRequeued());
        sb.append(", cancelled=").append(this.isCancelled());
        sb.append(']');
        return sb.toString();
    }

    public Long getBundleId() {
        return this.bundleId;
    }

    private void resolveDependencies() {
        TaskGraph graph = this.job.getTaskGraph();
        if (graph == null) {
            return;
        }
        if (!this.job.getJob().getClientSLA().isGraphTraversalInClient()) {
            return;
        }
        ArrayList dependencies = null;
        ArrayListHashMap dependenciesMap = null;
        JobResults jobResults = this.job.getJob().getResults();
        HashSet<Integer> nullResultPositions = new HashSet<Integer>();
        for (Task<?> task : this.tasks) {
            List list;
            TaskGraph.Node node = graph.nodeAt(task.getPosition());
            if (node == null || (list = node.getDependencies()) == null || list.isEmpty()) continue;
            for (TaskGraph.Node dep : list) {
                int depPosition;
                if (dependencies == null) {
                    dependencies = new ArrayList();
                    dependenciesMap = new ArrayListHashMap();
                }
                if (nullResultPositions.contains(depPosition = dep.getPosition())) continue;
                Task<?> depTask = jobResults.getResultTask(depPosition);
                if (depTask == null) {
                    log.warn("null dependency at position {} added to {}", (Object)depPosition, task);
                    nullResultPositions.add(depPosition);
                    continue;
                }
                dependencies.add(depTask);
                dependenciesMap.putValue((Object)task.getPosition(), (Object)depPosition);
            }
        }
        if (dependencies != null) {
            int[] depsPositions = new int[dependencies.size()];
            int count = 0;
            for (PositionalElement positionalElement : dependencies) {
                depsPositions[count++] = positionalElement.getPosition();
            }
            this.graphInfo = new TaskGraphInfo(dependencies.size(), dependenciesMap, depsPositions);
            this.graphInfo.setDependencies((List)dependencies);
        }
    }

    public TaskGraphInfo getGraphInfo() {
        return this.graphInfo;
    }
}

