/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.jppf.JPPFException;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.balancer.ChannelWrapper;
import org.jppf.client.balancer.ClientExecutionManager;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.execute.ExecutionManager;
import org.jppf.execute.ExecutorStatus;
import org.jppf.load.balancer.Bundler;
import org.jppf.load.balancer.BundlerHelper;
import org.jppf.load.balancer.persistence.LoadBalancerPersistenceManager;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.utils.CryptoUtils;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Pair;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWrapperLocal
extends ChannelWrapper
implements JPPFClientConnection {
    private static final Logger log = LoggerFactory.getLogger(ChannelWrapperLocal.class);
    private static final boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final ExecutionManager executionManager;
    private JPPFClientConnectionStatus status = JPPFClientConnectionStatus.ACTIVE;
    private final String connectionUuid = JPPFUuid.normalUUID();
    private final List<ClientConnectionStatusListener> listeners = new CopyOnWriteArrayList<ClientConnectionStatusListener>();
    private final JPPFClient client;
    private boolean closed;
    private final String name;

    public ChannelWrapperLocal(JPPFClient client) {
        this.client = client;
        this.name = client.getUuid() + "_local_executor";
        this.executionManager = new ClientExecutionManager(client.getConfig(), (JPPFProperty<Integer>)JPPFProperties.LOCAL_EXECUTION_THREADS);
        this.priority = (Integer)client.getConfig().get(JPPFProperties.LOCAL_EXECUTION_PRIORITY);
        this.systemInfo = new JPPFSystemInformation(client.getConfig(), this.getConnectionUuid(), true, false);
        this.managementInfo = new JPPFManagementInfo("local", "local", -1, this.getConnectionUuid(), 262145, false);
        this.managementInfo.setSystemInfo(this.systemInfo);
        String s = "client-local-executor";
        this.channelID = new Pair((Object)"client-local-executor", (Object)CryptoUtils.computeHash((String)"client-local-executor", (String)client.getBundlerFactory().getHashAlgorithm()));
    }

    public String getUuid() {
        return this.connectionUuid;
    }

    @Override
    public String getConnectionUuid() {
        return this.connectionUuid;
    }

    @Override
    public JPPFClientConnectionStatus getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(JPPFClientConnectionStatus status) {
        Object object = this.getMonitor();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.oldStatus = this.status;
            ExecutorStatus oldExecutionStatus = this.getExecutionStatus();
            JPPFClientConnectionStatus oldValue = this.status;
            if (debugEnabled) {
                log.debug("status changing from {} to {} for {}", new Object[]{oldValue, status, this});
            }
            this.status = status;
            if (oldValue.isTerminatedStatus()) {
                return;
            }
            this.fireStatusChanged(oldValue, this.status);
            ExecutorStatus newExecutionStatus = this.getExecutionStatus();
            this.fireExecutionStatusChanged(oldExecutionStatus, newExecutionStatus);
        }
    }

    @Override
    public void addClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeClientConnectionStatusListener(ClientConnectionStatusListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStatusChanged(JPPFClientConnectionStatus oldStatus, JPPFClientConnectionStatus newStatus) {
        if (this.isClosed() || oldStatus == newStatus) {
            return;
        }
        ClientConnectionStatusEvent event = new ClientConnectionStatusEvent(this, oldStatus);
        for (ClientConnectionStatusListener listener : this.listeners) {
            listener.statusChanged(event);
        }
    }

    public Future<?> submit(ClientTaskBundle bundle) {
        if (!this.isClosed()) {
            this.jobCount.set(1);
            if (debugEnabled) {
                log.debug("locally submitting {}", (Object)bundle);
            }
            this.setStatus(JPPFClientConnectionStatus.EXECUTING);
            LocalRunnable task = new LocalRunnable(bundle);
            bundle.jobDispatched(this);
            this.client.getExecutor().execute(task);
            if (debugEnabled) {
                log.debug("end locally submitting {}", (Object)bundle);
            }
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + "status=" + (Object)((Object)this.status) + ", connectionUuid=" + this.connectionUuid + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.getMonitor();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (debugEnabled) {
                log.debug("closing {}", (Object)this);
            }
            super.close();
            try {
                if (!this.status.isTerminatedStatus()) {
                    this.setStatus(JPPFClientConnectionStatus.CLOSED);
                }
                this.executionManager.shutdown();
            }
            finally {
                this.listenerList.clear();
                this.listeners.clear();
            }
        }
    }

    @Override
    public boolean cancel(ClientTaskBundle bundle) {
        if (bundle.isCancelled()) {
            return false;
        }
        if (debugEnabled) {
            log.debug("requesting cancel of jobId={}", (Object)bundle.getUuid());
        }
        bundle.cancel();
        try {
            this.executionManager.cancelAllTasks(true, false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    LoadBalancerPersistenceManager getLoadBalancerPersistenceManager() {
        return (LoadBalancerPersistenceManager)this.client.getLoadBalancerPersistenceManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.getMonitor();
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSSLEnabled() {
        return false;
    }

    @Override
    public String getHost() {
        return "local";
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getDriverUuid() {
        return null;
    }

    @Override
    public JPPFSystemInformation getSystemInfo() {
        return this.getSystemInformation();
    }

    @Override
    public JPPFConnectionPool getConnectionPool() {
        return null;
    }

    private class LocalRunnable
    implements Runnable {
        private final ClientTaskBundle bundle;

        public LocalRunnable(ClientTaskBundle bundle) {
            this.bundle = bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Exception exception = null;
            List<Task<?>> tasks = this.bundle.getTasksL();
            try {
                long start = System.nanoTime();
                DataProvider dataProvider = this.bundle.getJob().getDataProvider();
                for (Task<?> task : tasks) {
                    task.setDataProvider(dataProvider).setJob((JPPFDistributedJob)this.bundle.getJob());
                }
                ChannelWrapperLocal.this.executionManager.execute((TaskBundle)this.bundle, tasks);
                this.bundle.resultsReceived(tasks);
                double elapsed = System.nanoTime() - start;
                BundlerHelper.updateBundler((Bundler)ChannelWrapperLocal.this.bundler, (int)tasks.size(), (double)elapsed);
                ChannelWrapperLocal.this.getLoadBalancerPersistenceManager().storeBundler(ChannelWrapperLocal.this.channelID, ChannelWrapperLocal.this.bundler, ChannelWrapperLocal.this.bundlerAlgorithm);
                this.bundle.taskCompleted(exception);
            }
            catch (Throwable t) {
                try {
                    log.error(t.getMessage(), t);
                    exception = t instanceof Exception ? (Exception)t : new JPPFException(t);
                    this.bundle.resultsReceived(t);
                    this.bundle.taskCompleted(exception);
                }
                catch (Throwable throwable) {
                    this.bundle.taskCompleted(exception);
                    this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
                    ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                    ChannelWrapperLocal.this.jobCount.set(0);
                    throw throwable;
                }
                this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
                ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
                ChannelWrapperLocal.this.jobCount.set(0);
            }
            this.bundle.getClientJob().removeChannel(ChannelWrapperLocal.this);
            ChannelWrapperLocal.this.setStatus(JPPFClientConnectionStatus.ACTIVE);
            ChannelWrapperLocal.this.jobCount.set(0);
        }
    }
}

