/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.JPPFJob;
import org.jppf.client.balancer.ClientJob;
import org.jppf.client.balancer.ClientJobStatus;
import org.jppf.client.event.JobEvent;
import org.jppf.execute.ExecutorChannel;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.protocol.JobClientSLA;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.PropertiesCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractClientJob.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private volatile ClientJobStatus status = ClientJobStatus.NEW;
    private final List<Runnable> onDoneList = new ArrayList<Runnable>();
    private long jobReceivedTime;
    private transient long queueEntryTime;
    protected ClientJob parentJob;
    protected final JPPFJob job;
    private String uuid;
    private String name;
    JobSLA sla;
    private JobClientSLA clientSla;
    private JobMetadata metadata;
    private boolean jobExpired;
    private boolean pending;
    private final AtomicInteger dispatchCount = new AtomicInteger(0);
    private final Map<String, AtomicInteger> channelCounts = new HashMap<String, AtomicInteger>();

    protected AbstractClientJob(JPPFJob job) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (debugEnabled) {
            log.debug("creating ClientJob #" + INSTANCE_COUNT.incrementAndGet());
        }
        this.job = job;
        this.uuid = this.job.getUuid();
        this.name = this.job.getName();
        this.sla = this.job.getSLA();
        this.clientSla = this.job.getClientSLA();
        this.metadata = this.job.getMetadata();
    }

    public JPPFJob getJob() {
        return this.job;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobSLA getSLA() {
        return this.sla;
    }

    public JobClientSLA getClientSLA() {
        return this.clientSla;
    }

    public JobMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JobMetadata metadata) {
        this.metadata = metadata;
    }

    public void setSLA(JobSLA sla) {
        this.sla = sla;
    }

    public void setClientSLA(JobClientSLA clientSla) {
        this.clientSla = clientSla;
    }

    public boolean isJobExpired() {
        return this.jobExpired;
    }

    public void jobExpired() {
        this.jobExpired = true;
        this.cancel(true);
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    protected final boolean updateStatus(ClientJobStatus expect, ClientJobStatus newStatus) {
        if (this.status == expect) {
            if (newStatus == ClientJobStatus.EXECUTING && this.status != newStatus && !this.isParentBroadcastJob()) {
                this.job.fireJobEvent(JobEvent.Type.JOB_START, null, null);
            }
            this.status = newStatus;
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.status.compareTo(ClientJobStatus.EXECUTING) >= 0;
    }

    public boolean isCancelled() {
        return this.status.compareTo(ClientJobStatus.CANCELLED) >= 0;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.status.compareTo(ClientJobStatus.EXECUTING) > 0) {
            return false;
        }
        this.status = ClientJobStatus.CANCELLED;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        if (debugEnabled) {
            log.debug("job done: {}", (Object)this);
        }
        Runnable[] runnableArray = this.onDoneList;
        synchronized (this.onDoneList) {
            Runnable[] runnables = this.onDoneList.toArray(new Runnable[this.onDoneList.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Runnable runnable : runnables) {
                runnable.run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.remove(runnable);
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(ExecutorChannel<?> channel) {
        this.dispatchCount.incrementAndGet();
        String uuid = channel.getUuid();
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            AtomicInteger n = this.channelCounts.get(uuid);
            if (n == null) {
                this.channelCounts.put(uuid, new AtomicInteger(1));
            } else {
                n.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(ExecutorChannel<?> channel) {
        this.dispatchCount.decrementAndGet();
        String uuid = channel.getUuid();
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            int count;
            AtomicInteger n = this.channelCounts.get(uuid);
            if (n != null && (count = n.decrementAndGet()) <= 0) {
                this.channelCounts.remove(uuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getChannelDispatchCount(String uuid) {
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            AtomicInteger n = this.channelCounts.get(uuid);
            return n == null ? 0 : n.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getChannelCount() {
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            return this.channelCounts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasChannel(String uuid) {
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            return this.channelCounts.containsKey(uuid);
        }
    }

    public boolean acceptsChannel(ExecutorChannel<?> channel) {
        int n;
        int channelCount = this.getChannelCount();
        if (traceEnabled) {
            log.trace(String.format("job '%s' : cancelled=%b, cancelling=%b, pending=%b, expired=%b, nb dispatches=%d, nb channels=%d, max channels=%d", this.job.getName(), this.isCancelled(), this.isCancelling(), this.isPending(), this.isJobExpired(), this.dispatchCount.get(), channelCount, this.clientSla.getMaxChannels()));
        }
        if (this.isCancelling() || this.isCancelled() || this.isPending() || this.isJobExpired()) {
            return false;
        }
        if (!this.hasChannel(channel.getUuid()) && channelCount >= this.clientSla.getMaxChannels()) {
            return false;
        }
        if (!this.clientSla.isAllowMultipleDispatchesToSameChannel() && (n = this.getChannelDispatchCount(channel.getUuid())) > 0) {
            return false;
        }
        ExecutionPolicy policy = this.clientSla.getExecutionPolicy();
        boolean b = true;
        if (policy != null) {
            JPPFSystemInformation info = channel.getSystemInformation();
            this.preparePolicy(policy);
            b = policy.evaluate((PropertiesCollection)info);
            if (traceEnabled) {
                log.trace("policy result = " + b);
            }
        }
        return b;
    }

    public void preparePolicy(ExecutionPolicy policy) {
        if (policy == null) {
            return;
        }
        policy.setContext(this.sla, this.clientSla, this.metadata, this.dispatchCount.get(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChannels() {
        this.dispatchCount.set(0);
        Map<String, AtomicInteger> map = this.channelCounts;
        synchronized (map) {
            this.channelCounts.clear();
        }
    }

    boolean isParentBroadcastJob() {
        return this.sla.isBroadcastJob() && this.parentJob == null;
    }

    boolean isChildBroadcastJob() {
        return this.sla.isBroadcastJob() && this.parentJob != null;
    }

    public boolean isCancelling() {
        return this.job == null ? false : this.job.getCancellingFlag().get();
    }

    public boolean isCancellingOrCancelled() {
        return this.isCancelled() || this.isCancelling();
    }
}

