/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jppf.node.protocol.Task;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobResults
extends ThreadSynchronization
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(JobResults.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final SortedMap<Integer, Task<?>> resultMap = new TreeMap();
    private String jobName;

    public synchronized int size() {
        return this.resultMap.size();
    }

    public synchronized boolean hasResult(int position) {
        return this.resultMap.containsKey(position);
    }

    public synchronized Task<?> getResultTask(int position) {
        return (Task)this.resultMap.get(position);
    }

    public synchronized void addResults(List<Task<?>> tasks) {
        if (debugEnabled) {
            log.debug("adding {} results", (Object)tasks.size());
        }
        for (Task<?> task : tasks) {
            int pos = task.getPosition();
            if (debugEnabled) {
                log.debug("adding result at position {}", (Object)pos);
            }
            if (this.hasResult(pos)) {
                if (this.jobName == null) {
                    log.warn("position {} (out of {}) already has a result", (Object)pos, (Object)tasks.size());
                } else {
                    log.warn("position {} (out of {}) already has a result (job '{}')", new Object[]{pos, tasks.size(), this.jobName});
                }
            }
            this.resultMap.put(pos, task);
        }
    }

    public synchronized Collection<Task<?>> getAllResults() {
        return Collections.unmodifiableCollection(this.resultMap.values());
    }

    public synchronized List<Task<?>> getResultsList() {
        return new ArrayList(this.resultMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("size=").append(this.size());
        JobResults jobResults = this;
        synchronized (jobResults) {
            sb.append(", positions=").append(this.resultMap.keySet());
        }
        sb.append(']');
        return sb.toString();
    }

    public synchronized Task<?> waitForTask(int position) {
        return this.waitForTask(position, Long.MAX_VALUE);
    }

    public synchronized Task<?> waitForTask(int position, long timeout) {
        long start = System.nanoTime();
        while ((System.nanoTime() - start) / 1000000L < timeout && !this.hasResult(position)) {
            this.goToSleep(1L);
        }
        return this.getResultTask(position);
    }

    public synchronized void clear() {
        this.resultMap.clear();
    }

    void setJobName(String name) {
        this.jobName = name;
    }
}

