/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.comm.discovery.IPFilter;
import org.jppf.comm.discovery.JPPFConnectionInformation;
import org.jppf.comm.discovery.JPPFMulticastReceiver;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.SetHashMap;
import org.jppf.utils.concurrent.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JPPFMulticastReceiverThread
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JPPFMulticastReceiverThread.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final CollectionMap<String, JPPFConnectionInformation> infoMap = new SetHashMap();
    private final AtomicInteger count = new AtomicInteger(0);
    private final boolean acceptMultipleInterfaces;
    private final ConnectionHandler connectionHandler;
    private final IPFilter ipFilter;
    private Thread runningThread;

    JPPFMulticastReceiverThread(ConnectionHandler connectionHandler, IPFilter ipFilter, boolean acceptMultipleInterfaces) {
        if (connectionHandler == null) {
            throw new IllegalArgumentException("connectionHandler is null");
        }
        this.connectionHandler = connectionHandler;
        this.ipFilter = ipFilter;
        this.acceptMultipleInterfaces = acceptMultipleInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.runningThread = Thread.currentThread();
        JPPFMulticastReceiver receiver = null;
        try {
            receiver = new JPPFMulticastReceiver(this.ipFilter);
            while (!this.isStopped()) {
                JPPFConnectionInformation info = receiver.receive();
                if (this.isStopped()) {
                    return;
                }
                JPPFMulticastReceiverThread jPPFMulticastReceiverThread = this;
                synchronized (jPPFMulticastReceiverThread) {
                    if (info != null && !this.hasConnectionInformation(info)) {
                        if (debugEnabled) {
                            log.debug("Found connection information: " + info);
                        }
                        this.addConnectionInformation(info);
                        this.onNewConnection("jppf_discovery-" + this.count.incrementAndGet(), info);
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (receiver != null) {
                receiver.setStopped(true);
            }
        }
    }

    protected synchronized void onNewConnection(String name, JPPFConnectionInformation info) {
        this.connectionHandler.onNewConnection(name, info);
    }

    private boolean hasConnectionInformation(JPPFConnectionInformation info) {
        if (this.acceptMultipleInterfaces && this.infoMap.containsValue((Object)info.uuid, (Object)info)) {
            return true;
        }
        if (this.infoMap.containsKey((Object)info.uuid)) {
            return true;
        }
        for (JPPFConnectionInformation tmp : this.infoMap) {
            if (!info.isSame(tmp, false)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addConnectionInformation(JPPFConnectionInformation info) {
        this.infoMap.putValue((Object)info.uuid, (Object)info);
    }

    public synchronized boolean removeConnectionInformation(String uuid) {
        return this.infoMap.removeKey((Object)uuid) != null;
    }

    public synchronized boolean removeConnectionInformation(JPPFConnectionInformation info) {
        if (this.acceptMultipleInterfaces) {
            return this.infoMap.removeValue((Object)info.uuid, (Object)info);
        }
        return this.infoMap.removeKey((Object)info.uuid) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.setStopped(true);
        if (this.runningThread != null) {
            block6: {
                try {
                    this.runningThread.interrupt();
                }
                catch (Exception e) {
                    if (!debugEnabled) break block6;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            this.runningThread = null;
            JPPFMulticastReceiverThread jPPFMulticastReceiverThread = this;
            synchronized (jPPFMulticastReceiverThread) {
                this.infoMap.clear();
            }
        }
    }

    public static interface ConnectionHandler {
        public void onNewConnection(String var1, JPPFConnectionInformation var2);
    }
}

