/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jppf.JPPFException;
import org.jppf.client.AbstractJPPFJob;
import org.jppf.client.JobDependencyIdSupplier;
import org.jppf.client.JobResults;
import org.jppf.client.JobStatus;
import org.jppf.client.balancer.ClientTaskBundle;
import org.jppf.client.event.JobEvent;
import org.jppf.client.event.JobListener;
import org.jppf.client.persistence.JobPersistence;
import org.jppf.client.persistence.JobPersistenceException;
import org.jppf.client.taskwrapper.JPPFAnnotatedTask;
import org.jppf.execute.ExecutorChannel;
import org.jppf.node.protocol.JobDependencySpec;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.graph.TaskNode;
import org.jppf.utils.DateTimeUtils;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.JPPFRunnableTask;
import org.jppf.utils.JPPFUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFJob
extends AbstractJPPFJob<JPPFJob>
implements Iterable<Task<?>>,
Future<List<Task<?>>> {
    private static Logger log = LoggerFactory.getLogger(JPPFJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final long serialVersionUID = 1L;

    public JPPFJob() {
        this(JPPFUuid.normalUUID());
    }

    public JPPFJob(String jobUuid) {
        super(jobUuid);
        this.results.setJobName(this.name);
    }

    public List<Task<?>> getJobTasks() {
        return this.tasks;
    }

    public void addAll(List<Task<?>> tasks) throws JPPFException {
        int pos = this.tasks.size();
        for (Task<?> task : tasks) {
            task.setPosition(pos++);
        }
        this.tasks.addAll(tasks);
    }

    public Task<?> add(Object taskObject, Object ... args) throws JPPFException {
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        Object jppfTask = null;
        jppfTask = taskObject instanceof Task ? (Task)taskObject : new JPPFAnnotatedTask(taskObject, args);
        this.tasks.add(jppfTask);
        jppfTask.setPosition(this.tasks.size() - 1);
        return jppfTask;
    }

    public Task<?> add(String method, Object taskObject, Object ... args) throws JPPFException {
        if (taskObject == null) {
            throw new JPPFException("null tasks are not accepted");
        }
        JPPFAnnotatedTask jppfTask = new JPPFAnnotatedTask(taskObject, method, args);
        this.tasks.add(jppfTask);
        jppfTask.setPosition(this.tasks.size() - 1);
        return jppfTask;
    }

    public Task<?> add(Task<?> task) throws JPPFException {
        if (this.tasks.contains(task)) {
            return task;
        }
        return task instanceof TaskNode ? this.addWithDependencies((TaskNode)task) : this.add(task, (Object[])null);
    }

    private Task<?> addWithDependencies(TaskNode<?> task) throws JPPFException {
        if (this.tasks.contains(task)) {
            return task;
        }
        this.taskGraph = true;
        Task<?> result = this.add(task, (Object[])null);
        if (task.hasDependency()) {
            for (TaskNode dep : task.getDependencies()) {
                this.addWithDependencies(dep);
            }
        }
        return result;
    }

    public Task<?> add(Runnable runnable) throws JPPFException {
        return this.add(runnable, (Object[])null);
    }

    public Task<?> add(JPPFRunnableTask runnable) throws JPPFException {
        return this.add(runnable, (Object[])null);
    }

    public Task<?> add(Callable<?> callable) throws JPPFException {
        return this.add(callable, (Object[])null);
    }

    public Task<?> add(JPPFCallable<?> callable) throws JPPFException {
        return this.add(callable, (Object[])null);
    }

    public void addJobListener(JobListener listener) {
        this.listeners.add(listener);
    }

    public void removeJobListener(JobListener listener) {
        this.listeners.remove(listener);
    }

    public void fireJobEvent(JobEvent.Type type, ExecutorChannel<ClientTaskBundle> channel, List<Task<?>> tasks) {
        if (log.isDebugEnabled()) {
            log.debug("firing {} event with {} tasks for {}, connection = {}", new Object[]{type, tasks == null ? 0 : tasks.size(), this, channel});
        }
        JobEvent event = new JobEvent(this, channel, tasks);
        switch (type) {
            case JOB_START: {
                for (JobListener listener : this.listeners) {
                    listener.jobStarted(event);
                }
                break;
            }
            case JOB_END: {
                for (JobListener listener : this.listeners) {
                    listener.jobEnded(event);
                }
                break;
            }
            case JOB_DISPATCH: {
                for (JobListener listener : this.listeners) {
                    listener.jobDispatched(event);
                }
                break;
            }
            case JOB_RETURN: {
                for (JobListener listener : this.listeners) {
                    listener.jobReturned(event);
                }
                break;
            }
        }
    }

    public <T> JobPersistence<T> getPersistenceManager() {
        return this.persistenceManager;
    }

    public <T> JPPFJob setPersistenceManager(JobPersistence<T> persistenceManager) {
        this.persistenceManager = persistenceManager;
        return this;
    }

    @Override
    public Iterator<Task<?>> iterator() {
        return this.tasks.iterator();
    }

    public List<Task<?>> awaitResults() {
        return this.awaitResults(Long.MAX_VALUE);
    }

    public List<Task<?>> awaitResults(long timeout) {
        try {
            this.await(timeout, false);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
        return this.results.getResultsList();
    }

    public List<Task<?>> getAllResults() {
        return this.results.getResultsList();
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        block9: {
            if (log.isDebugEnabled()) {
                log.debug("request to cancel {}, client={}", (Object)this, (Object)this.client);
            }
            if (this.getCancellingFlag().compareAndSet(false, true)) {
                try {
                    if (!mayInterruptIfRunning && this.getStatus() == JobStatus.EXECUTING) break block9;
                    try {
                        if (this.client != null) {
                            boolean bl = this.client.cancelJob(this.uuid);
                            return bl;
                        }
                    }
                    catch (Exception e) {
                        log.error("error cancelling job {} : {}", (Object)this, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                finally {
                    this.getCancellingFlag().set(false);
                }
            }
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.cancelled.get() || this.unexecutedTaskCount() <= 0;
    }

    @Override
    public List<Task<?>> get() throws InterruptedException, ExecutionException {
        try {
            this.await(Long.MAX_VALUE, false);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return this.results.getResultsList();
    }

    @Override
    public List<Task<?>> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.await(DateTimeUtils.toMillis((long)timeout, (TimeUnit)unit), true);
        return this.results.getResultsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultsReceived(List<Task<?>> tasks, Throwable throwable, boolean sendJobEvent) {
        JobResults jobResults = this.results;
        synchronized (jobResults) {
            int unexecutedTaskCount = 0;
            if (tasks != null) {
                this.results.addResults(tasks);
                unexecutedTaskCount = this.unexecutedTaskCount();
                if (debugEnabled) {
                    log.debug("Received results for {} tasks, pendingCount={}, count={}, jobResults={}", new Object[]{tasks.size(), unexecutedTaskCount, tasks.size(), this.results});
                }
                if (this.persistenceManager != null) {
                    try {
                        JobPersistence pm = this.persistenceManager;
                        pm.storeJob(pm.computeKey(this), this, tasks);
                    }
                    catch (JobPersistenceException e) {
                        log.error(e.getMessage(), (Throwable)((Object)e));
                    }
                }
            } else if (debugEnabled) {
                log.debug("received throwable '{}'", (Object)ExceptionUtils.getMessage((Throwable)throwable));
            }
            if (sendJobEvent) {
                this.fireJobEvent(JobEvent.Type.JOB_RETURN, null, tasks);
                if (unexecutedTaskCount <= 0) {
                    this.fireJobEvent(JobEvent.Type.JOB_END, null, tasks);
                }
            }
            this.client.unregisterClassLoaders(this.uuid);
        }
        this.results.wakeUp();
    }

    public boolean hasTaskGraph() {
        return this.taskGraph;
    }

    public JPPFJob setDependencyId(Supplier<String> idSupplier) {
        this.getSLA().getDependencySpec().setId(idSupplier.get());
        return this;
    }

    public JPPFJob setDependencyId(JobDependencyIdSupplier idSupplier) {
        this.getSLA().getDependencySpec().setId(idSupplier.getId(this));
        return this;
    }

    public JPPFJob setDependencyId(String id) {
        this.getSLA().getDependencySpec().setId(id);
        return this;
    }

    public JPPFJob setUuidAsDependencyId() {
        return this.setDependencyId(this.getUuid());
    }

    public JPPFJob setNameAsDependencyId() {
        return this.setDependencyId(this.getName());
    }

    public JPPFJob addDependencies(JPPFJob ... dependencies) {
        JobDependencySpec spec = this.getSLA().getDependencySpec();
        for (JPPFJob dependency : dependencies) {
            spec.addDependencies(new String[]{dependency.getSLA().getDependencySpec().getId()});
        }
        return this;
    }

    public JPPFJob addDependencies(Collection<JPPFJob> dependencies) {
        JobDependencySpec spec = this.getSLA().getDependencySpec();
        for (JPPFJob dependency : dependencies) {
            spec.addDependencies(new String[]{dependency.getSLA().getDependencySpec().getId()});
        }
        return this;
    }

    public JPPFJob setGraphRoot(boolean graphRoot) {
        this.getSLA().getDependencySpec().setGraphRoot(graphRoot);
        return this;
    }

    public JPPFJob setCascadeCancellation(boolean cascadeCancellation) {
        this.getSLA().getDependencySpec().setCascadeCancellation(cascadeCancellation);
        return this;
    }
}

