/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobStatus;
import org.jppf.job.JobSelector;
import org.jppf.job.JobUuidSelector;
import org.jppf.job.persistence.PersistedJobsManagerMBean;
import org.jppf.job.persistence.PersistenceInfoImpl;
import org.jppf.job.persistence.PersistenceObjectType;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.node.protocol.DataProvider;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.node.protocol.TaskBundle;
import org.jppf.serialization.JPPFSerialization;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFDriverJobPersistence {
    private static Logger log = LoggerFactory.getLogger(JPPFDriverJobPersistence.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private final JMXDriverConnectionWrapper jmx;
    private final PersistedJobsManagerMBean persistedJobsManager;

    public JPPFDriverJobPersistence(JMXDriverConnectionWrapper jmx) {
        this.jmx = jmx;
        try {
            this.persistedJobsManager = this.jmx.getPersistedJobsManager();
            if (this.persistedJobsManager == null) {
                throw new IllegalStateException("persistedJobsManager is null");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<String> listJobs(JobSelector selector) throws Exception {
        List result = this.persistedJobsManager.getPersistedJobUuids(selector);
        if (debugEnabled) {
            log.debug("found jobs: {}", (Object)result);
        }
        return result;
    }

    public boolean deleteJob(String uuid) throws Exception {
        List result = this.persistedJobsManager.deletePersistedJobs((JobSelector)new JobUuidSelector(new String[]{uuid}));
        return result != null && result.contains(uuid);
    }

    public List<String> deleteJobs(JobSelector selector) throws Exception {
        List result = this.persistedJobsManager.deletePersistedJobs(selector);
        if (debugEnabled) {
            log.debug("deleted jobs: {}", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFJob retrieveJob(String uuid) throws Exception {
        int i;
        TaskBundle header = (TaskBundle)this.load(uuid, PersistenceObjectType.JOB_HEADER, -1);
        if (debugEnabled) {
            log.debug("got job header for uuid={} : {}", (Object)uuid, (Object)header);
        }
        if (header == null) {
            return null;
        }
        JPPFJob job = new JPPFJob(header.getUuid());
        job.setName(header.getName());
        job.setSLA(header.getSLA());
        job.setMetadata(header.getMetadata());
        int[][] positions = this.persistedJobsManager.getPersistedJobPositions(uuid);
        if (debugEnabled) {
            log.debug("got task positions for uuid={} : {}", (Object)uuid, (Object)StringUtils.buildString((String)", ", (String)"{", (String)"}", (int[])positions[0]));
        }
        if (debugEnabled) {
            log.debug("got result positions for uuid={} : {}", (Object)uuid, (Object)StringUtils.buildString((String)", ", (String)"{", (String)"}", (int[])positions[1]));
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            Arrays.sort(positions[i2]);
        }
        ArrayList<PersistenceInfoImpl> toLoad = new ArrayList<PersistenceInfoImpl>(1 + positions[0].length + positions[1].length);
        toLoad.add(new PersistenceInfoImpl(uuid, null, PersistenceObjectType.DATA_PROVIDER, -1, null));
        for (i = 0; i < positions[0].length; ++i) {
            toLoad.add(new PersistenceInfoImpl(uuid, null, PersistenceObjectType.TASK, positions[0][i], null));
        }
        for (i = 0; i < positions[1].length; ++i) {
            toLoad.add(new PersistenceInfoImpl(uuid, null, PersistenceObjectType.TASK_RESULT, positions[1][i], null));
        }
        long requestId = -1L;
        try {
            requestId = this.persistedJobsManager.requestLoad(toLoad);
            DataProvider dataProvider = (DataProvider)this.load(requestId, uuid, PersistenceObjectType.DATA_PROVIDER, -1);
            if (traceEnabled) {
                log.trace("got dataprovider for uuid={} : {}", (Object)uuid, (Object)dataProvider);
            }
            job.setDataProvider(dataProvider);
            for (int i3 = 0; i3 < positions[0].length; ++i3) {
                Task task = (Task)this.load(requestId, uuid, PersistenceObjectType.TASK, positions[0][i3]);
                if (traceEnabled) {
                    log.trace(String.format("got task at position %d for uuid=%s : %s", positions[0][i3], uuid, task));
                }
                job.add(task);
            }
            ArrayList results = new ArrayList(positions[1].length);
            for (int i4 = 0; i4 < positions[1].length; ++i4) {
                Task task = (Task)this.load(requestId, uuid, PersistenceObjectType.TASK_RESULT, positions[1][i4]);
                if (traceEnabled) {
                    log.trace(String.format("got task result at position %d for uuid=%s : %s", positions[1][i4], uuid, task));
                }
                results.add(task);
            }
            job.getResults().addResults(results);
            if (job.unexecutedTaskCount() <= 0) {
                job.setStatus(JobStatus.COMPLETE);
            }
        }
        finally {
            if (requestId >= 0L) {
                this.persistedJobsManager.deleteLoadRequest(requestId);
            }
        }
        return job;
    }

    public JPPFDistributedJob getJobDescription(String uuid) throws Exception {
        return (JPPFDistributedJob)this.load(uuid, PersistenceObjectType.JOB_HEADER, -1);
    }

    public boolean isJobComplete(String uuid) throws Exception {
        return this.persistedJobsManager.isJobComplete(uuid);
    }

    private <T> T load(String uuid, PersistenceObjectType type, int position) throws Exception {
        byte[] bytes = (byte[])this.persistedJobsManager.getPersistedJobObject(uuid, type, position);
        if (bytes == null) {
            return null;
        }
        if (traceEnabled) {
            log.trace("got byte[{}]", (Object)bytes.length);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Object object = JPPFSerialization.Factory.getSerialization().deserialize((InputStream)is);
            return (T)object;
        }
    }

    private <T> T load(long requestId, String uuid, PersistenceObjectType type, int position) throws Exception {
        byte[] bytes = (byte[])this.persistedJobsManager.getPersistedJobObject(requestId, uuid, type, position);
        if (bytes == null) {
            return null;
        }
        if (traceEnabled) {
            log.trace("got byte[{}]", (Object)bytes.length);
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Object object = JPPFSerialization.Factory.getSerialization().deserialize((InputStream)is);
            return (T)object;
        }
    }
}

