/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jppf.client.AbstractGenericClient;
import org.jppf.client.ConnectionPoolFilter;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.JPPFJob;
import org.jppf.client.JobManager;
import org.jppf.client.balancer.JobManagerClient;
import org.jppf.client.balancer.queue.JPPFPriorityQueue;
import org.jppf.client.debug.Debug;
import org.jppf.client.event.ConnectionPoolListener;
import org.jppf.discovery.ClientDriverDiscovery;
import org.jppf.discovery.DriverDiscovery;
import org.jppf.job.AllJobsSelector;
import org.jppf.job.JobSelector;
import org.jppf.load.balancer.LoadBalancingInformation;
import org.jppf.load.balancer.spi.JPPFBundlerFactory;
import org.jppf.node.policy.ExecutionPolicy;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Operator;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.concurrent.ConcurrentUtils;
import org.jppf.utils.concurrent.MutableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFClient
extends AbstractGenericClient {
    private static Logger log = LoggerFactory.getLogger(JPPFClient.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    public JPPFClient() {
        this(null, JPPFConfiguration.getProperties(), new ConnectionPoolListener[0]);
    }

    public JPPFClient(String uuid) {
        this(uuid, JPPFConfiguration.getProperties(), new ConnectionPoolListener[0]);
    }

    public JPPFClient(ConnectionPoolListener ... listeners) {
        this(null, JPPFConfiguration.getProperties(), listeners);
    }

    public JPPFClient(String uuid, ConnectionPoolListener ... listeners) {
        this(uuid, JPPFConfiguration.getProperties(), listeners);
    }

    public JPPFClient(TypedProperties config, ConnectionPoolListener ... listeners) {
        this(null, config, listeners);
    }

    public JPPFClient(String uuid, TypedProperties config, ConnectionPoolListener ... listeners) {
        super(uuid, config, listeners);
        Debug.register(this);
    }

    @Override
    JPPFClientConnectionImpl createConnection(String name, JPPFConnectionPool pool) {
        return new JPPFClientConnectionImpl(this, name, pool);
    }

    public List<Task<?>> submitJob(JPPFJob job) {
        if (job.isBlocking()) {
            return this.submit(job);
        }
        this.submitAsync(job);
        return null;
    }

    public List<Task<?>> submit(JPPFJob job) {
        this.preSubmit(job);
        this.getJobManager().submitJob(job);
        return job.awaitResults();
    }

    public JPPFJob submitAsync(JPPFJob job) {
        this.preSubmit(job);
        this.getJobManager().submitJob(job);
        return job;
    }

    private void preSubmit(JPPFJob job) {
        if (this.isClosed()) {
            throw new IllegalStateException("this client is closed");
        }
        if (job == null) {
            throw new IllegalArgumentException("job cannot be null");
        }
        if (job.getJobTasks().isEmpty()) {
            throw new IllegalStateException("job cannot be empty");
        }
        if (job.client != null) {
            if (!job.isDone()) {
                throw new IllegalStateException("this job is already submitted");
            }
            job.cancelled.set(false);
            job.getResults().clear();
        }
        job.client = this;
        if (debugEnabled) {
            log.debug("submitting job {}", (Object)job);
        }
        ExecutionPolicy defaultPolicy = this.getDefaultPolicy();
        ExecutionPolicy jobPolicy = job.getSLA().getExecutionPolicy();
        if (jobPolicy == null && defaultPolicy != null) {
            job.getSLA().setExecutionPolicy(defaultPolicy);
        }
        defaultPolicy = this.getDefaultClientPolicy();
        jobPolicy = job.getClientSLA().getExecutionPolicy();
        if (jobPolicy == null && defaultPolicy != null) {
            job.getClientSLA().setExecutionPolicy(defaultPolicy);
        }
        if (log.isTraceEnabled()) {
            job.forEach(t -> log.trace("task {}, pos={}, taskObject={}, taskObject class={}", new Object[]{t, t.getPosition(), t.getTaskObject(), t.getTaskObject() != null ? t.getTaskObject().getClass() : null}));
        }
    }

    @Override
    protected JobManager createJobManager() {
        JobManagerClient jobManager = null;
        try {
            jobManager = new JobManagerClient(this, this.bundlerFactory);
        }
        catch (Exception e) {
            log.error("Can't initialize job Manager", (Throwable)e);
        }
        return jobManager;
    }

    public void reset() {
        if (this.isClosed()) {
            return;
        }
        if (debugEnabled) {
            log.debug("resetting client");
        }
        if (this.resetting.compareAndSet(false, true)) {
            this.close(true);
            JPPFConfiguration.reset();
            this.init(JPPFConfiguration.getProperties());
        }
    }

    public void reset(TypedProperties configuration) {
        if (this.isClosed()) {
            return;
        }
        if (debugEnabled) {
            log.debug("resetting client");
        }
        if (this.resetting.compareAndSet(false, true)) {
            this.close(true);
            this.init(configuration);
        }
    }

    public JPPFConnectionPool awaitActiveConnectionPool() {
        return this.awaitConnectionPool(Long.MAX_VALUE, JPPFClientConnectionStatus.ACTIVE);
    }

    public JPPFConnectionPool awaitWorkingConnectionPool() {
        return this.awaitConnectionPool(Long.MAX_VALUE, JPPFClientConnectionStatus.ACTIVE, JPPFClientConnectionStatus.EXECUTING);
    }

    public JPPFConnectionPool awaitConnectionPool(JPPFClientConnectionStatus ... statuses) {
        return this.awaitConnectionPool(Long.MAX_VALUE, statuses);
    }

    public JPPFConnectionPool awaitConnectionPool(long timeout, JPPFClientConnectionStatus ... statuses) {
        List<JPPFConnectionPool> list = this.awaitConnectionPools(timeout, statuses);
        return list.isEmpty() ? null : list.get(0);
    }

    public List<JPPFConnectionPool> awaitWorkingConnectionPools() {
        return this.awaitConnectionPools(Long.MAX_VALUE, JPPFClientConnectionStatus.ACTIVE, JPPFClientConnectionStatus.EXECUTING);
    }

    public List<JPPFConnectionPool> awaitWorkingConnectionPools(long timeout) {
        return this.awaitConnectionPools(timeout, JPPFClientConnectionStatus.ACTIVE, JPPFClientConnectionStatus.EXECUTING);
    }

    public List<JPPFConnectionPool> awaitConnectionPools(long timeout, JPPFClientConnectionStatus ... statuses) {
        MutableReference ref = new MutableReference();
        ConcurrentUtils.awaitCondition(() -> !((List)ref.setSynchronized(this.findConnectionPools(statuses), (Object)this.pools)).isEmpty(), (long)timeout, (long)10L, (boolean)false);
        return (List)ref.get();
    }

    public List<JPPFConnectionPool> awaitConnectionPools(ComparisonOperator operator, int expectedConnections, long timeout, JPPFClientConnectionStatus ... statuses) {
        return this.awaitConnectionPools((ComparisonOperator)Operator.AT_LEAST, 1, operator, expectedConnections, timeout, statuses);
    }

    public List<JPPFConnectionPool> awaitConnectionPools(ComparisonOperator poolOperator, int expectedPools, ComparisonOperator connectionOperator, int expectedConnections, long timeout, JPPFClientConnectionStatus ... statuses) {
        ArrayList<JPPFConnectionPool> result = new ArrayList<JPPFConnectionPool>();
        ConcurrentUtils.awaitCondition(() -> {
            if (!result.isEmpty()) {
                result.clear();
            }
            List<JPPFConnectionPool> temp = this.findConnectionPools(statuses);
            for (JPPFConnectionPool pool : temp) {
                List<JPPFClientConnection> list = pool.getConnections(statuses);
                if (!connectionOperator.evaluate((long)list.size(), (long)expectedConnections)) continue;
                result.add(pool);
            }
            return poolOperator.evaluate((long)result.size(), (long)expectedPools);
        }, (long)timeout, (long)10L, (boolean)false);
        return result;
    }

    public List<JPPFConnectionPool> awaitConnectionPools(long timeout, ConnectionPoolFilter<JPPFConnectionPool> filter) {
        ArrayList<JPPFConnectionPool> result = new ArrayList<JPPFConnectionPool>();
        ConcurrentUtils.awaitCondition(() -> {
            List<JPPFConnectionPool> temp = this.getConnectionPools();
            for (JPPFConnectionPool pool : temp) {
                if (filter != null && !filter.accepts(pool)) continue;
                result.add(pool);
            }
            return !result.isEmpty();
        }, (long)timeout, (long)10L, (boolean)false);
        return result;
    }

    @Override
    public void close() {
        log.info("closing {}", (Object)this);
        Debug.unregister(this);
        super.close();
    }

    public void removeDriverDiscovery(ClientDriverDiscovery discovery) {
        this.discoveryHandler.removeDiscovery((DriverDiscovery)discovery);
    }

    public LoadBalancingInformation getLoadBalancerSettings() {
        JobManager manager = this.getJobManager();
        return manager == null ? null : manager.getLoadBalancerSettings();
    }

    public void setLoadBalancerSettings(String algorithm, Properties parameters) throws Exception {
        JobManager manager = this.getJobManager();
        if (manager != null) {
            manager.setLoadBalancerSettings(algorithm, parameters);
        }
    }

    public JPPFBundlerFactory getBundlerFactory() {
        return this.bundlerFactory;
    }

    public int nbIdleCOnnections() {
        JobManagerClient manager = (JobManagerClient)this.getJobManager();
        return manager == null ? -1 : manager.nbAvailableConnections();
    }

    public ExecutionPolicy getDefaultPolicy() {
        return (ExecutionPolicy)this.defaultPolicy.get();
    }

    public void setDefaultPolicy(ExecutionPolicy defaultPolicy) {
        this.defaultPolicy.set(defaultPolicy);
    }

    public ExecutionPolicy getDefaultClientPolicy() {
        return (ExecutionPolicy)this.defaultClientPolicy.get();
    }

    public void setDefaultClientPolicy(ExecutionPolicy defaultClientPolicy) {
        this.defaultClientPolicy.set(defaultClientPolicy);
    }

    public List<JPPFJob> getQueuedJobs() {
        return this.getQueuedJobs(null);
    }

    public List<JPPFJob> getQueuedJobs(JobSelector selector) {
        JPPFPriorityQueue queue = ((JobManagerClient)this.getJobManager()).getQueue();
        List<JPPFJob> allJobs = queue.getJPPFJobs();
        if (selector == null || selector instanceof AllJobsSelector) {
            return allJobs;
        }
        ArrayList<JPPFJob> result = new ArrayList<JPPFJob>(allJobs.size() < 10 ? 10 : allJobs.size());
        for (JPPFJob job : allJobs) {
            if (!selector.accepts((JPPFDistributedJob)job)) continue;
            result.add(job);
        }
        return result;
    }

    public int getQueuedJobsCount() {
        return this.getQueuedJobsCount(null);
    }

    public int getQueuedJobsCount(JobSelector selector) {
        JPPFPriorityQueue queue = ((JobManagerClient)this.getJobManager()).getQueue();
        if (selector == null || selector instanceof AllJobsSelector) {
            return queue.getQueueSize();
        }
        List<JPPFJob> allJobs = queue.getJPPFJobs();
        int result = 0;
        for (JPPFJob job : allJobs) {
            if (!selector.accepts((JPPFDistributedJob)job)) continue;
            ++result;
        }
        return result;
    }
}

