/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.List;
import org.jppf.client.AbstractConnectionPool;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.HostIP;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Operator;
import org.jppf.utils.concurrent.ConcurrentUtils;
import org.jppf.utils.concurrent.MutableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMXConnectionPool
extends AbstractConnectionPool<JMXDriverConnectionWrapper> {
    private static Logger log = LoggerFactory.getLogger(JMXConnectionPool.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private HostIP hostIP;
    private int port = -1;
    private final boolean sslEnabled;

    public JMXConnectionPool(int size, boolean sslEnabled) {
        super(size);
        this.sslEnabled = sslEnabled;
    }

    @Override
    public JMXDriverConnectionWrapper getConnection() {
        int count = 0;
        int size = this.connectionCount();
        while (count++ < size) {
            JMXDriverConnectionWrapper jmx = (JMXDriverConnectionWrapper)this.nextConnection();
            if (!jmx.isConnected()) continue;
            return jmx;
        }
        return null;
    }

    synchronized List<JMXDriverConnectionWrapper> getConnections(boolean connectedOnly) {
        if (!connectedOnly) {
            return this.getConnections();
        }
        ArrayList<JMXDriverConnectionWrapper> list = new ArrayList<JMXDriverConnectionWrapper>();
        for (JMXDriverConnectionWrapper connection : this.getConnections()) {
            if (!connection.isConnected()) continue;
            list.add(connection);
        }
        return list;
    }

    @Override
    public synchronized int setSize(int maxSize) {
        if (debugEnabled) {
            log.debug("requesting new maxSize={}, current maxSize={}", (Object)maxSize, (Object)this.size);
        }
        if (maxSize == this.size) {
            return this.size;
        }
        int diff = maxSize - this.size;
        int size = this.connectionCount();
        if (diff < 0) {
            int actual;
            int i = size;
            for (actual = 0; --i >= 0 && actual < -diff; ++actual) {
                JMXDriverConnectionWrapper c = (JMXDriverConnectionWrapper)this.connections.get(i);
                if (debugEnabled) {
                    log.debug("removing connection {} from pool {}", (Object)c, (Object)this);
                }
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.remove(c);
            }
            this.size -= actual;
        } else {
            for (int i = 0; i < diff; ++i) {
                JMXDriverConnectionWrapper c = new JMXDriverConnectionWrapper(this.hostIP.ipAddress(), this.port, this.sslEnabled);
                this.add(c);
                c.connect();
            }
            this.size += diff;
        }
        return this.size;
    }

    synchronized int getPort() {
        return this.port;
    }

    synchronized void setPort(int port) {
        if (this.port < 0 && port >= 0) {
            this.port = port;
            if (this.hostIP != null) {
                this.initializeConnections();
            }
        }
    }

    synchronized void setDriverHostIP(HostIP hostIP) {
        if (this.hostIP == null && hostIP != null) {
            this.hostIP = hostIP;
            if (this.port >= 0) {
                this.initializeConnections();
            }
        }
    }

    private void initializeConnections() {
        int n = 0;
        n = this.connectionCount();
        if (n < this.size) {
            for (int i = n; i < this.size; ++i) {
                JMXDriverConnectionWrapper jmx = new JMXDriverConnectionWrapper(this.hostIP.ipAddress(), this.port, this.sslEnabled);
                this.add(jmx);
                jmx.connect();
            }
        }
    }

    List<JMXDriverConnectionWrapper> awaitJMXConnections(ComparisonOperator operator, int nbConnections, long timeout, boolean connected) {
        Operator op = operator == null ? Operator.EQUAL : operator;
        MutableReference ref = new MutableReference();
        ConcurrentUtils.awaitCondition(() -> this.lambda$awaitJMXConnections$0((ComparisonOperator)op, ref, connected, nbConnections), (long)timeout, (long)10L, (boolean)false);
        return (List)ref.get();
    }

    private /* synthetic */ boolean lambda$awaitJMXConnections$0(ComparisonOperator op, MutableReference ref, boolean connected, int nbConnections) {
        return op.evaluate((long)((List)ref.set(this.getConnections(connected))).size(), (long)nbConnections);
    }
}

