/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jppf.client.AbstractGenericClient;
import org.jppf.discovery.ClientConnectionPoolInfo;
import org.jppf.discovery.DriverConnectionInfo;
import org.jppf.discovery.DriverDiscoveryListener;

class ClientDriverDiscoveryListener
implements DriverDiscoveryListener<ClientConnectionPoolInfo> {
    private final AbstractGenericClient client;
    private final Set<DriverConnectionInfo> discoveredPools = new HashSet<DriverConnectionInfo>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    ClientDriverDiscoveryListener(AbstractGenericClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onNewConnection(ClientConnectionPoolInfo info) {
        if (this.closed.get()) {
            return false;
        }
        boolean hasPool = false;
        Set<DriverConnectionInfo> set = this.discoveredPools;
        synchronized (set) {
            hasPool = this.discoveredPools.contains(info);
            if (!hasPool) {
                this.discoveredPools.add((DriverConnectionInfo)info);
            }
        }
        if (!hasPool) {
            this.client.newConnectionPool(info);
        }
        return !hasPool;
    }

    boolean onPoolRemoved(ClientConnectionPoolInfo info) {
        return this.discoveredPools.remove(info);
    }

    ClientDriverDiscoveryListener open() {
        this.closed.set(false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientDriverDiscoveryListener close() {
        if (this.closed.compareAndSet(true, false)) {
            Set<DriverConnectionInfo> set = this.discoveredPools;
            synchronized (set) {
                this.discoveredPools.clear();
            }
        }
        return this;
    }
}

