/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.JPPFException;
import org.jppf.client.AbstractClassServerDelegate;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.comm.interceptor.InterceptorHandler;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassServerDelegateImpl
extends AbstractClassServerDelegate {
    private static Logger log = LoggerFactory.getLogger(ClassServerDelegateImpl.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);

    ClassServerDelegateImpl(JPPFClientConnection owner, String uuid, String host, int port) throws Exception {
        super(owner);
        this.clientUuid = uuid;
        this.host = host;
        this.port = port;
    }

    @Override
    public final void init() throws Exception {
        if (this.owner.isClosed()) {
            log.warn("attempting to init closed " + this.getClass().getSimpleName() + ", aborting");
            return;
        }
        this.handshakeDone = false;
        if (this.socketClient == null) {
            this.initSocketClient();
        }
        boolean sysoutEnabled = this.owner.getConnectionPool().getClient().isSysoutEnabled();
        String msg = String.format("[client: %s] Attempting connection to the class server at %s:%d", this.getName(), this.host, this.port);
        if (sysoutEnabled) {
            System.out.println(msg);
        }
        log.info(msg);
        if (!this.socketInitializer.initialize(this.socketClient)) {
            throw new JPPFException('[' + this.getName() + "] Could not reconnect to the class server");
        }
        if (!InterceptorHandler.invokeOnConnect((SocketWrapper)this.socketClient)) {
            throw new JPPFException('[' + this.getName() + "] Could not reconnect to the class server due to interceptor failure");
        }
        if (!this.socketInitializer.isClosed()) {
            msg = "[client: " + this.getName() + "] Reconnected to the class server";
            if (sysoutEnabled) {
                System.out.println(msg);
            }
            log.info(msg);
        }
        if (!this.handshakeDone) {
            this.handshake();
        }
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setUncaughtExceptionHandler(this);
            while (!this.stop && !this.isClosed()) {
                try {
                    if (!this.handshakeDone) {
                        this.handshake();
                    }
                    this.processNextRequest();
                }
                catch (Exception e) {
                    if (this.isClosed()) continue;
                    if (debugEnabled) {
                        log.debug('[' + this.getName() + "] caught " + e + ", will re-initialise ...", (Throwable)e);
                    } else {
                        log.warn('[' + this.getName() + "] caught " + ExceptionUtils.getMessage((Throwable)e) + ", will re-initialise ...");
                    }
                    JPPFClientConnectionImpl c = (JPPFClientConnectionImpl)this.owner;
                    c.setStatus(JPPFClientConnectionStatus.DISCONNECTED);
                    c.submitInitialization();
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error('[' + this.getName() + "] " + e.getMessage(), (Throwable)e);
            this.close();
        }
    }
}

