/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jppf.client.ConnectionPool;
import org.jppf.client.ConnectionPoolFilter;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.client.JPPFConnectionPool;
import org.jppf.client.event.ClientConnectionStatusEvent;
import org.jppf.client.event.ClientConnectionStatusListener;
import org.jppf.client.event.ConnectionPoolEvent;
import org.jppf.client.event.ConnectionPoolListener;
import org.jppf.utils.JPPFUuid;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.SystemUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.VersionUtils;
import org.jppf.utils.collections.CollectionMap;
import org.jppf.utils.collections.DescendingIntegerComparator;
import org.jppf.utils.collections.LinkedListSortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFClient
implements ClientConnectionStatusListener,
AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(AbstractJPPFClient.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    static String SERIALIZATION_HELPER_IMPL = "org.jppf.utils.SerializationHelperImpl";
    protected static String JCA_SERIALIZATION_HELPER = "org.jppf.jca.serialization.JcaSerializationHelperImpl";
    final AtomicInteger poolSequence = new AtomicInteger(0);
    final CollectionMap<Integer, JPPFConnectionPool> pools = new LinkedListSortedMap((Comparator)new DescendingIntegerComparator());
    private String uuid = null;
    private final List<ConnectionPoolListener> connectionPoolListeners = new CopyOnWriteArrayList<ConnectionPoolListener>();
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean resetting = new AtomicBoolean(false);
    private String serializationHelperClassName;
    protected TypedProperties config;

    protected AbstractJPPFClient(String uuid) {
        String string = this.uuid = uuid == null ? JPPFUuid.normalUUID() : uuid;
        if (debugEnabled) {
            log.debug("Instantiating JPPF client with uuid=" + this.uuid);
        }
        VersionUtils.logVersionInformation((String)"client", (String)this.uuid);
        SystemUtils.printPidAndUuid((String)"client", (String)this.uuid);
    }

    public TypedProperties getConfig() {
        return this.config;
    }

    abstract void initPools(TypedProperties var1);

    public int getAllConnectionsCount() {
        int count = 0;
        for (JPPFConnectionPool pool : this.pools) {
            count += pool.connectionCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFClientConnection getClientConnection(int priority, JPPFClientConnectionStatus ... statuses) {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            Collection pls = this.pools.getValues((Object)priority);
            if (pls == null) {
                return null;
            }
            for (JPPFConnectionPool pool : pls) {
                List<JPPFClientConnection> list = pool.getConnections(statuses);
                if (list.isEmpty()) continue;
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public void statusChanged(ClientConnectionStatusEvent event) {
        JPPFClientConnection c = event.getClientConnection();
        if (c.getStatus().isTerminatedStatus() && !event.getOldStatus().isTerminatedStatus()) {
            this.connectionFailed(c);
        }
    }

    abstract void connectionFailed(JPPFClientConnection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeClientConnection(JPPFClientConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (debugEnabled) {
            log.debug("removing connection {}", (Object)connection);
        }
        connection.removeClientConnectionStatusListener(this);
        JPPFConnectionPool pool = connection.getConnectionPool();
        boolean poolRemoved = false;
        if (pool != null) {
            pool.remove(connection);
            if (pool.isEmpty()) {
                CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
                synchronized (collectionMap) {
                    this.pools.removeValue((Object)pool.getPriority(), (Object)pool);
                }
                poolRemoved = true;
            }
        }
        return poolRemoved;
    }

    @Override
    public void close() {
        for (JPPFConnectionPool pool : this.getConnectionPools()) {
            pool.close();
        }
        this.pools.clear();
    }

    public void addConnectionPoolListener(ConnectionPoolListener listener) {
        this.connectionPoolListeners.add(listener);
    }

    public void removeConnectionPoolListener(ConnectionPoolListener listener) {
        this.connectionPoolListeners.remove(listener);
    }

    void fireConnectionRemoved(JPPFClientConnection c) {
        ConnectionPoolEvent event = new ConnectionPoolEvent(c.getConnectionPool(), c);
        for (ConnectionPoolListener listener : this.connectionPoolListeners) {
            listener.connectionRemoved(event);
        }
    }

    void fireConnectionAdded(JPPFClientConnection c) {
        ConnectionPoolEvent event = new ConnectionPoolEvent(c.getConnectionPool(), c);
        for (ConnectionPoolListener listener : this.connectionPoolListeners) {
            listener.connectionAdded(event);
        }
    }

    void fireConnectionPoolRemoved(JPPFConnectionPool pool) {
        ConnectionPoolEvent event = new ConnectionPoolEvent(pool);
        for (ConnectionPoolListener listener : this.connectionPoolListeners) {
            listener.connectionPoolRemoved(event);
        }
    }

    void fireConnectionPoolAdded(JPPFConnectionPool pool) {
        ConnectionPoolEvent event = new ConnectionPoolEvent(pool);
        for (ConnectionPoolListener listener : this.connectionPoolListeners) {
            listener.connectionPoolAdded(event);
        }
    }

    void newConnection(JPPFClientConnectionImpl c) {
        this.fireConnectionAdded(c);
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    protected String getSerializationHelperClassName() {
        if (this.serializationHelperClassName == null) {
            this.serializationHelperClassName = this.getConfig().getString("jppf.serialization.helper.class", SERIALIZATION_HELPER_IMPL);
        }
        return this.serializationHelperClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool<?> findConnectionPool(int priority, int poolId) {
        JPPFConnectionPool pool = null;
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            Collection priorityPools = this.pools.getValues((Object)priority);
            if (priorityPools != null) {
                for (JPPFConnectionPool p : priorityPools) {
                    if (p.getId() != poolId) continue;
                    pool = p;
                    break;
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFConnectionPool findConnectionPool(int poolId) {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            for (JPPFConnectionPool pool : this.pools) {
                if (pool.getId() != poolId) continue;
                return pool;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFConnectionPool findConnectionPool(String name) {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            for (JPPFConnectionPool pool : this.pools) {
                if (!pool.getName().equals(name)) continue;
                return pool;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFConnectionPool> findConnectionPools(JPPFClientConnectionStatus ... statuses) {
        ArrayList<JPPFConnectionPool> list = new ArrayList<JPPFConnectionPool>();
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            for (JPPFConnectionPool pool : this.pools) {
                if (pool.getConnections(statuses).isEmpty()) continue;
                list.add(pool);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFConnectionPool> findConnectionPools(ConnectionPoolFilter<JPPFConnectionPool> filter) {
        ArrayList<JPPFConnectionPool> list = new ArrayList<JPPFConnectionPool>();
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            for (JPPFConnectionPool pool : this.pools) {
                if (filter != null && !filter.accepts(pool)) continue;
                list.add(pool);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFConnectionPool> findConnectionPools(String pattern) {
        Pattern p = Pattern.compile(pattern);
        ArrayList<JPPFConnectionPool> result = new ArrayList<JPPFConnectionPool>();
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            for (JPPFConnectionPool pool : this.pools) {
                if (!p.matcher(pool.getName()).matches()) continue;
                result.add(pool);
            }
        }
        return result;
    }

    public JPPFConnectionPool getConnectionPool() {
        List<JPPFConnectionPool> list = this.findConnectionPools(JPPFClientConnectionStatus.ACTIVE);
        return list.isEmpty() ? null : list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFConnectionPool> getConnectionPools(int priority) {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            Collection coll = this.pools.getValues((Object)priority);
            if (coll != null) {
                ArrayList<JPPFConnectionPool> list = new ArrayList<JPPFConnectionPool>(coll.size());
                list.addAll(coll);
                return list;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPoolPriorities() {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            return new ArrayList<Integer>(this.pools.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JPPFConnectionPool> getConnectionPools() {
        CollectionMap<Integer, JPPFConnectionPool> collectionMap = this.pools;
        synchronized (collectionMap) {
            return new ArrayList<JPPFConnectionPool>(this.pools.allValues());
        }
    }

    public boolean isResetting() {
        return this.resetting.get();
    }
}

