/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.client.AbstractConnectionPool;
import org.jppf.client.JMXConnectionPool;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnection;
import org.jppf.client.JPPFClientConnectionStatus;
import org.jppf.discovery.ClientConnectionPoolInfo;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.utils.HostIP;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientConnectionPool
extends AbstractConnectionPool<JPPFClientConnection>
implements Comparable<AbstractClientConnectionPool> {
    private static Logger log = LoggerFactory.getLogger(AbstractClientConnectionPool.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    final int priority;
    final int id;
    final String name;
    final JPPFClient client;
    final boolean sslEnabled;
    final AtomicInteger sequence = new AtomicInteger(0);
    int driverPort = -1;
    String driverUuid;
    JPPFSystemInformation systemInfo;
    final JMXConnectionPool jmxPool;
    HostIP hostIP;
    ClientConnectionPoolInfo discoveryInfo;
    int maxJobs;

    AbstractClientConnectionPool(JPPFClient client, int id, String name, int priority, int size, boolean sslEnabled, int jmxPoolSize, int maxJobs) {
        super(size);
        this.client = client;
        this.id = id;
        this.priority = priority;
        this.name = name;
        this.sslEnabled = sslEnabled;
        this.jmxPool = new JMXConnectionPool(jmxPoolSize, sslEnabled);
        this.maxJobs = maxJobs;
    }

    AbstractClientConnectionPool(JPPFClient client, int id, ClientConnectionPoolInfo info) {
        this(client, id, info.getName(), info.getPriority(), info.getPoolSize(), info.isSecure(), info.getJmxPoolSize(), info.getMaxJobs());
        this.discoveryInfo = info;
    }

    @Override
    public synchronized JPPFClientConnection getConnection() {
        int count = 0;
        int size = this.connections.size();
        while (count++ < size) {
            JPPFClientConnection c = (JPPFClientConnection)this.nextConnection();
            if (c.getStatus() != JPPFClientConnectionStatus.ACTIVE) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connectionCount(JPPFClientConnectionStatus ... statuses) {
        AbstractClientConnectionPool abstractClientConnectionPool = this;
        synchronized (abstractClientConnectionPool) {
            if (statuses == null || statuses.length <= 0) {
                return this.connections.size();
            }
        }
        int count = 0;
        for (JPPFClientConnection c : this.getConnections()) {
            if (!this.connectionHasStatus(c, true, statuses)) continue;
            ++count;
        }
        return count;
    }

    public int getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public String getName() {
        return this.name;
    }

    public synchronized String getDriverUuid() {
        return this.driverUuid;
    }

    synchronized void setDriverUuid(String uuid) {
        if (this.driverUuid == null) {
            this.driverUuid = uuid;
        }
    }

    @Override
    public int compareTo(AbstractClientConnectionPool other) {
        if (other == null) {
            return 1;
        }
        return this.priority > other.priority ? -1 : (this.priority < other.priority ? 1 : 0);
    }

    public int hashCode() {
        return 31 + this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id == ((AbstractClientConnectionPool)obj).id;
    }

    public List<JPPFClientConnection> getConnections(JPPFClientConnectionStatus ... statuses) {
        ArrayList<JPPFClientConnection> list = new ArrayList<JPPFClientConnection>(this.getSize());
        for (JPPFClientConnection c : this.getConnections()) {
            if (!this.connectionHasStatus(c, true, statuses)) continue;
            list.add(c);
        }
        if (log.isTraceEnabled()) {
            log.trace("statuses={}, got connections {}", Arrays.asList(statuses), list);
        }
        return list;
    }

    boolean connectionHasStatus(JPPFClientConnection connection, boolean has, JPPFClientConnectionStatus ... statuses) {
        if (connection == null) {
            return !has;
        }
        if (statuses == null || statuses.length <= 0) {
            return has;
        }
        JPPFClientConnectionStatus status = connection.getStatus();
        for (JPPFClientConnectionStatus s : statuses) {
            if (status != s) continue;
            return has;
        }
        return !has;
    }

    int nextSequence() {
        return this.sequence.incrementAndGet();
    }

    synchronized void setDriverHostIP(HostIP hostIP) {
        this.hostIP = hostIP;
        this.jmxPool.setDriverHostIP(hostIP);
    }

    public synchronized String getDriverHost() {
        return this.hostIP != null ? this.hostIP.hostName() : null;
    }

    public synchronized String getDriverIPAddress() {
        return this.hostIP != null ? this.hostIP.ipAddress() : null;
    }

    public synchronized int getDriverPort() {
        return this.driverPort;
    }

    synchronized void setDriverPort(int driverPort) {
        if (this.driverPort < 0) {
            this.driverPort = driverPort;
        }
    }

    public JPPFClient getClient() {
        return this.client;
    }

    public synchronized JPPFSystemInformation getSystemInfo() {
        return this.systemInfo;
    }

    synchronized void setSystemInfo(JPPFSystemInformation systemInfo) {
        this.systemInfo = systemInfo;
    }

    public int getJmxPort() {
        return this.jmxPool.getPort();
    }

    void setJmxPort(int jmxPort) {
        this.jmxPool.setPort(jmxPort);
    }

    public JMXDriverConnectionWrapper getJmxConnection() {
        return this.jmxPool.getConnection();
    }

    public JMXDriverConnectionWrapper getJmxConnection(boolean connectedOnly) {
        return connectedOnly ? this.jmxPool.getConnection() : (JMXDriverConnectionWrapper)this.jmxPool.nextConnection();
    }

    public int getJMXPoolMaxSize() {
        return this.jmxPool.getSize();
    }

    public int setJMXPoolMaxSize(int maxSize) {
        return this.jmxPool.setSize(maxSize);
    }

    public int getJMXPoolSize() {
        return this.jmxPool.getSize();
    }

    public int setJMXPoolSize(int maxSize) {
        return this.jmxPool.setSize(maxSize);
    }

    public int getMaxJobs() {
        return this.maxJobs;
    }

    public int setMaxJobs(int maxJobs) {
        if (maxJobs > 0) {
            this.maxJobs = maxJobs;
        }
        return this.maxJobs;
    }

    public List<JMXDriverConnectionWrapper> getJMXConnections() {
        return this.jmxPool.getConnections();
    }

    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing {}", (Object)this);
        }
        super.close();
        this.jmxPool.close();
    }

    ClientConnectionPoolInfo getDiscoveryInfo() {
        return this.discoveryInfo;
    }
}

