/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import org.jppf.client.ClientConnectionHandler;
import org.jppf.client.JPPFClientConnection;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.ssl.SSLHelper;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientConnectionHandler
implements ClientConnectionHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractClientConnectionHandler.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    SocketWrapper socketClient;
    SocketInitializer socketInitializer;
    private long maxSocketIdleMillis;
    String host;
    int port = -1;
    JPPFClientConnection owner;
    String name;

    protected AbstractClientConnectionHandler(JPPFClientConnection owner, String name) {
        this.owner = owner;
        this.name = name;
        TypedProperties config = owner.getConnectionPool().getClient().getConfig();
        long configSocketIdle = (Long)config.get(JPPFProperties.SOCKET_MAX_IDLE);
        this.maxSocketIdleMillis = configSocketIdle > 10L ? configSocketIdle * 1000L : -1L;
        this.socketInitializer = SocketInitializer.Factory.newInstance((TypedProperties)config);
    }

    @Override
    public SocketWrapper getSocketClient() throws Exception {
        if (this.maxSocketIdleMillis > 10000L && (System.nanoTime() - this.socketClient.getSocketTimestamp()) / 1000000L > this.maxSocketIdleMillis) {
            this.close();
            this.init();
        }
        return this.socketClient;
    }

    protected void createSSLConnection() throws Exception {
        this.socketClient = SSLHelper.createSSLClientConnection((SocketWrapper)this.socketClient);
    }

    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing " + this.name);
        }
        try {
            if (this.socketInitializer != null) {
                this.socketInitializer.close();
            }
            if (this.socketClient != null) {
                this.socketClient.close();
            }
            this.socketClient = null;
        }
        catch (Exception e) {
            log.error('[' + this.name + "] " + e.getMessage(), (Throwable)e);
        }
        if (debugEnabled) {
            log.debug(this.name + " closed");
        }
    }

    @Override
    public boolean isClosed() {
        return this.owner.isClosed();
    }

    public SocketInitializer getSocketInitializer() {
        return this.socketInitializer;
    }
}

