/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jppf.classloader.JPPFResourceWrapper;
import org.jppf.classloader.ResourceIdentifier;
import org.jppf.classloader.ResourceProvider;
import org.jppf.client.AbstractClientConnectionHandler;
import org.jppf.client.ClassServerDelegate;
import org.jppf.client.ClientResourceProvider;
import org.jppf.client.JPPFClientConnection;
import org.jppf.comm.socket.SocketClient;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.io.IOHelper;
import org.jppf.serialization.ObjectSerializer;
import org.jppf.utils.JPPFIdentifiers;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.configuration.JPPFProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassServerDelegate
extends AbstractClientConnectionHandler
implements ClassServerDelegate,
Thread.UncaughtExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(AbstractClassServerDelegate.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private final boolean FILE_LOOKUP;
    protected boolean stop;
    protected final ResourceProvider resourceProvider = new ClientResourceProvider();
    protected String clientUuid;
    protected boolean handshakeDone;
    protected final String formattedName;

    protected AbstractClassServerDelegate(JPPFClientConnection owner) {
        super(owner, owner.getName() + " - ClassServer");
        this.FILE_LOOKUP = (Boolean)owner.getConnectionPool().getClient().getConfig().get(JPPFProperties.CLASSLOADER_FILE_LOOKUP);
        this.formattedName = "[" + this.name + ']';
        if (debugEnabled) {
            log.debug("resourceProvider={}", (Object)this.resourceProvider);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void initSocketClient() throws Exception {
        this.socketClient = new SocketClient();
        this.socketClient.setHost(this.host);
        this.socketClient.setPort(this.port);
    }

    protected JPPFResourceWrapper readResource() throws Exception {
        if (debugEnabled) {
            log.debug("{} reading next resource ...", (Object)this.formattedName);
        }
        return (JPPFResourceWrapper)IOHelper.unwrappedData((SocketWrapper)this.socketClient, (ObjectSerializer)this.socketClient.getSerializer());
    }

    protected void writeResource(JPPFResourceWrapper resource) throws Exception {
        IOHelper.sendData((SocketWrapper)this.socketClient, (Object)resource, (ObjectSerializer)this.socketClient.getSerializer());
        this.socketClient.flush();
        if (debugEnabled) {
            log.debug(this.formattedName + " data sent to the server");
        }
    }

    protected void handshake() throws Exception {
        if (debugEnabled) {
            log.debug("{} : sending channel identifier {}", (Object)this.formattedName, (Object)JPPFIdentifiers.asString((int)65531));
        }
        this.socketClient.writeInt(65531);
        if (this.owner.isSSLEnabled()) {
            this.createSSLConnection();
        }
        if (debugEnabled) {
            log.debug("{} : sending initial resource", (Object)this.formattedName);
        }
        JPPFResourceWrapper resource = new JPPFResourceWrapper();
        resource.setState(JPPFResourceWrapper.State.PROVIDER_INITIATION);
        resource.addUuid(this.clientUuid);
        resource.setData(ResourceIdentifier.CONNECTION_UUID, (Object)this.owner.getConnectionUuid());
        this.writeResource(resource);
        this.readResource();
        this.handshakeDone = true;
        if (debugEnabled) {
            log.debug("{} : server handshake done", (Object)this.formattedName);
        }
    }

    protected void processNextRequest() throws Exception {
        boolean fileLookup;
        boolean found = true;
        JPPFResourceWrapper resource = this.readResource();
        String name = resource.getName();
        if (debugEnabled) {
            log.debug("{} resource requested: {}, requestUuid={}, resourceIds={}", new Object[]{this.formattedName, resource, resource.getRequestUuid(), resource.getResourceIds()});
        }
        Collection<ClassLoader> loaders = this.owner.getConnectionPool().getClient().getRegisteredClassLoaders(resource.getRequestUuid());
        if (debugEnabled) {
            log.debug("{} using classloaders={}", (Object)this.formattedName, loaders);
        }
        boolean bl = fileLookup = (Boolean)resource.getData(ResourceIdentifier.FILE_LOOKUP_ALLOWED, (Object)true) != false && this.FILE_LOOKUP;
        if (resource.getData(ResourceIdentifier.MULTIPLE) != null) {
            List list = this.resourceProvider.getMultipleResourcesAsBytes(name, loaders, fileLookup);
            if (list != null) {
                resource.setData(ResourceIdentifier.RESOURCE_LIST, (Object)list);
            }
        } else if (resource.getData(ResourceIdentifier.MULTIPLE_NAMES) != null) {
            String[] names = (String[])resource.getData(ResourceIdentifier.MULTIPLE_NAMES);
            Map result = this.resourceProvider.getMultipleResourcesAsBytes(loaders, fileLookup, names);
            resource.setData(ResourceIdentifier.RESOURCE_MAP, (Object)result);
        } else {
            byte[] callable = resource.getCallable();
            byte[] b = callable != null ? this.resourceProvider.computeCallable(callable) : this.resourceProvider.getResource(name, loaders, fileLookup);
            if (b == null) {
                found = false;
            }
            if (callable == null) {
                resource.setDefinition(b);
            } else {
                resource.setCallable(b);
            }
            if (debugEnabled) {
                if (found) {
                    log.debug("{} found resource: {} ({} bytes)", new Object[]{this.formattedName, name, b.length});
                } else {
                    log.debug("{} resource not found: {}", (Object)this.formattedName, (Object)name);
                }
            }
        }
        resource.setState(JPPFResourceWrapper.State.PROVIDER_RESPONSE);
        this.writeResource(resource);
    }

    @Override
    public void close() {
        if (debugEnabled) {
            log.debug("closing {}", (Object)this.getName());
        }
        this.stop = true;
        super.close();
        if (debugEnabled) {
            log.debug("{} closed", (Object)this.getName());
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error("uncaught exception", e);
    }
}

