/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import scipy.interpolate.BSpline;
import scipy.interpolate.BSplineUtil;
import sklearn.Transformer;

public class BSplineTransformer
extends Transformer {
    public BSplineTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        BSpline bspline = this.getBSpline();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        List<DefineFunction> splineFunctions = BSplineUtil.createSplineFunction(bspline, encoder);
        DefineFunction splineFunction = (DefineFunction)Iterables.getOnlyElement(splineFunctions);
        Apply apply = ExpressionUtil.createApply((DefineFunction)splineFunction, (Expression[])new Expression[]{continuousFeature.ref()});
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("bspline", continuousFeature), (Expression)apply);
        return Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    public BSpline getBSpline() {
        return (BSpline)this.get("bspline", BSpline.class);
    }
}

