/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.expression;

import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.PMMLEncoder;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static ContinuousFeature toFeature(String name, Expression expression, PMMLEncoder encoder) {
        FieldRef fieldRef;
        DerivedField derivedField = null;
        if (expression instanceof FieldRef && (derivedField = encoder.getDerivedField((fieldRef = (FieldRef)expression).requireField())) != null) {
            DataType dataType = derivedField.requireDataType();
            OpType opType = derivedField.requireOpType();
            switch (dataType) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    break;
                }
                default: {
                    derivedField = null;
                }
            }
            switch (opType) {
                case CONTINUOUS: {
                    break;
                }
                default: {
                    derivedField = null;
                }
            }
        }
        if (derivedField == null) {
            derivedField = encoder.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
        }
        return new ContinuousFeature(encoder, derivedField);
    }
}

