/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.TypeUtil;
import sklearn.HasMultiType;
import sklearn.SkLearnTransformer;
import sklearn.preprocessing.EncoderUtil;

public abstract class BaseEncoder
extends SkLearnTransformer
implements HasMultiType {
    public BaseEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType getDataType(int index) {
        List<List<Object>> categories = this.getCategories();
        List<Object> featureCategories = categories.get(index);
        featureCategories = featureCategories.stream().filter(category -> !EncoderUtil.isMissingCategory(category)).collect(Collectors.toList());
        return TypeUtil.getDataType(featureCategories, (DataType)DataType.STRING);
    }

    public List<List<Object>> getCategories() {
        return this.getArrayList("categories_", Object.class);
    }
}

