/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neural_network;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.Schema;
import org.jpmml.python.HasArray;
import sklearn.SkLearnClassifier;
import sklearn.neural_network.MLPConstants;
import sklearn.neural_network.MultilayerPerceptronUtil;

public class MLPClassifier
extends SkLearnClassifier
implements MLPConstants {
    public MLPClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<HasArray> coefs = this.getCoefs();
        return MultilayerPerceptronUtil.getNumberOfFeatures(coefs);
    }

    @Override
    public int getNumberOfOutputs() {
        return 1;
    }

    public NeuralNetwork encodeModel(Schema schema) {
        String activation = this.getActivation();
        List<HasArray> coefs = this.getCoefs();
        List<HasArray> intercepts = this.getIntercepts();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        NeuralNetwork neuralNetwork = MultilayerPerceptronUtil.encodeNeuralNetwork(MiningFunction.CLASSIFICATION, activation, coefs, intercepts, schema);
        this.encodePredictProbaOutput((Model)neuralNetwork, DataType.DOUBLE, (DiscreteLabel)categoricalLabel);
        return neuralNetwork;
    }

    public String getActivation() {
        return (String)this.getEnum("activation", arg_0 -> ((MLPClassifier)this).getString(arg_0), ENUM_ACTIVATION);
    }

    public List<HasArray> getCoefs() {
        return this.getArrayList("coefs_");
    }

    public List<HasArray> getIntercepts() {
        return this.getArrayList("intercepts_");
    }
}

