/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.stacking;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasEstimatorEnsemble;
import sklearn.Regressor;
import sklearn.SkLearnRegressor;
import sklearn.StepUtil;
import sklearn.ensemble.stacking.StackingUtil;

public class StackingRegressor
extends SkLearnRegressor
implements HasEstimatorEnsemble<Regressor> {
    public StackingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        List<Regressor> estimators = this.getEstimators();
        return StepUtil.getNumberOfFeatures(estimators);
    }

    public MiningModel encodeModel(Schema schema) {
        List<Regressor> estimators = this.getEstimators();
        Regressor finalEstimator = this.getFinalEstimator();
        Boolean passthrough = this.getPassthrough();
        List<String> stackMethod = this.getStackMethod();
        final ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        StackingUtil.PredictFunction predictFunction = new StackingUtil.PredictFunction(){

            @Override
            public List<Feature> apply(int index, Model model, String stackMethod, SkLearnEncoder encoder) {
                switch (stackMethod) {
                    case "predict": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(stackMethod);
                    }
                }
                Feature feature = encoder.exportPrediction(model, FieldNameUtil.create((String)"predict", (Object[])new Object[]{index}), (ScalarLabel)continuousLabel);
                return Collections.singletonList(feature);
            }
        };
        return StackingUtil.encodeStacking(estimators, stackMethod, predictFunction, finalEstimator, passthrough, schema);
    }

    @Override
    public List<Regressor> getEstimators() {
        return this.getList("estimators_", Regressor.class);
    }

    public Regressor getFinalEstimator() {
        return (Regressor)this.get("final_estimator_", Regressor.class);
    }

    public Boolean getPassthrough() {
        return this.getBoolean("passthrough");
    }

    public List<String> getStackMethod() {
        return this.getEnumList("stack_method_", arg_0 -> ((StackingRegressor)this).getStringList(arg_0), Arrays.asList("predict"));
    }
}

