/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    private static final String PEP440_REGEX = "(\\d+)\\.(\\d+)(?:(?:a|b|rc)\\d)?(?:\\.(?:(\\d)|(?:(?:post|dev)?\\d?)))*";
    private static final Pattern PEP440_VERSION = Pattern.compile("(\\d+)\\.(\\d+)(?:(?:a|b|rc)\\d)?(?:\\.(?:(\\d)|(?:(?:post|dev)?\\d?)))*");

    private VersionUtil() {
    }

    public static int compareVersion(String left, String right) {
        List<Integer> leftTokens = VersionUtil.parseVersion(left);
        List<Integer> rightTokens = VersionUtil.parseVersion(right);
        for (int i = 0; i < Math.min(leftTokens.size(), rightTokens.size()); ++i) {
            int diff = Integer.compare(leftTokens.get(i), rightTokens.get(i));
            if (diff == 0) continue;
            return diff;
        }
        if (leftTokens.size() < rightTokens.size() && rightTokens.get(leftTokens.size()) != 0) {
            return -1;
        }
        return 0;
    }

    public static List<Integer> parseVersion(String string) {
        String token;
        Matcher matcher = PEP440_VERSION.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string);
        }
        ArrayList<Integer> tokens = new ArrayList<Integer>();
        for (int i = 1; i <= 3 && (token = matcher.group(i)) != null; ++i) {
            tokens.add(Integer.valueOf(token));
        }
        return tokens;
    }
}

