/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import pandas.core.CategoricalDtype;
import sklearn.Transformer;

public class CastTransformer
extends Transformer {
    public CastTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        TypeInfo dtype = this.getDType();
        DataType dataType = dtype.getDataType();
        OpType opType = TypeUtil.getOpType((DataType)dataType);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Object feature = features.get(i);
            if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                wildcardFeature = this.refineWildcardFeature(wildcardFeature, opType, dataType, encoder);
                if (dtype instanceof CategoricalDtype) {
                    CategoricalDtype categoricalDtype = (CategoricalDtype)dtype;
                    Boolean ordered = categoricalDtype.getOrdered();
                    List values = categoricalDtype.getValues();
                    feature = ordered.booleanValue() ? wildcardFeature.toOrdinalFeature(values) : wildcardFeature.toCategoricalFeature(values);
                } else {
                    feature = wildcardFeature;
                }
            } else if (feature.getDataType() != dataType) {
                FieldRef fieldRef = feature.ref();
                DerivedField derivedField = encoder.ensureDerivedField(this.createFieldName(dataType.name().toLowerCase(), feature), opType, dataType, () -> fieldRef);
                feature = FeatureUtil.createFeature((Field)derivedField, (PMMLEncoder)encoder);
            }
            result.add((Feature)feature);
        }
        return result;
    }

    public TypeInfo getDType() {
        if (this.containsKey("dtype_")) {
            return this.getDType("dtype_", true);
        }
        return this.getDType("dtype", true);
    }
}

