/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.postprocessing;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Decision;
import org.dmg.pmml.Decisions;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.python.TupleUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn2pmml.preprocessing.ExpressionTransformer;

public class BusinessDecisionTransformer
extends Transformer {
    public BusinessDecisionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Expression expression;
        Transformer transformer = this.getTransformer();
        String businessProblem = this.getBusinessProblem();
        List<Object[]> decisions = this.getDecisions();
        if (!encoder.hasModel()) {
            throw new IllegalStateException("Model is undefined");
        }
        Model model = encoder.getModel();
        if (transformer != null) {
            features = transformer.encode(features, encoder);
        }
        SchemaUtil.checkSize((int)1, features);
        Feature feature = features.get(0);
        DerivedField derivedField = (DerivedField)feature.getField();
        DataType dataType = derivedField.requireDataType();
        OpType opType = derivedField.requireOpType();
        switch (opType) {
            case CONTINUOUS: {
                opType = OpType.CATEGORICAL;
                break;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
        }
        if (this.isEmbedded()) {
            expression = derivedField.getExpression();
            encoder.removeDerivedField(derivedField.requireName());
        } else {
            expression = feature.ref();
        }
        Decisions pmmlDecisions = new Decisions().setBusinessProblem(businessProblem);
        for (Object[] decision : decisions) {
            Decision pmmlDecision = new Decision().setValue(TupleUtil.extractElement((Object[])decision, (int)0, Object.class)).setDescription((String)TupleUtil.extractElement((Object[])decision, (int)1, String.class));
            pmmlDecisions.addDecisions(new Decision[]{pmmlDecision});
        }
        OutputField outputField = new OutputField(this.createFieldName("decision", feature), opType, dataType).setResultFeature(ResultFeature.DECISION).setFinalResult(Boolean.valueOf(true)).setExpression(expression).setDecisions(pmmlDecisions);
        DerivedOutputField decisionDerivedField = encoder.createDerivedField(model, outputField, true);
        feature = FeatureUtil.createFeature((Field)decisionDerivedField, (PMMLEncoder)encoder);
        return Collections.singletonList(feature);
    }

    public String getBusinessProblem() {
        return this.getString("business_problem");
    }

    public List<Object[]> getDecisions() {
        return this.getTupleList("decisions");
    }

    public Transformer getTransformer() {
        if (this.containsKey("expr")) {
            String expr = this.getString("expr");
            Object dtype = this.getOptionalObject("dtype");
            ExpressionTransformer expressionTransformer = new ExpressionTransformer().setExpr(expr).setDType(dtype);
            return expressionTransformer;
        }
        return (Transformer)this.getOptional("transformer_", Transformer.class);
    }

    private boolean isEmbedded() {
        if (this.containsKey("expr")) {
            return true;
        }
        Object transformer = this.getOptionalObject("transformer");
        if (transformer != null) {
            if (transformer instanceof String) {
                return true;
            }
            if (transformer instanceof Transformer) {
                return true;
            }
        }
        return false;
    }
}

