/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.python.SliceUtil;
import sklearn.SkLearnClusterer;
import sklearn.neighbors.HasMetric;
import sklearn.neighbors.HasNumberOfNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class NearestNeighbors
extends SkLearnClusterer
implements HasMetric,
HasNumberOfNeighbors,
HasTrainingData {
    public NearestNeighbors(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public int getNumberOfOutputs() {
        return 0;
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        return KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLUSTERING, numberOfInstances, numberOfFeatures, schema);
    }

    @Override
    public String getMetric() {
        return this.getString("metric");
    }

    @Override
    public int getP() {
        return this.getInteger("p");
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.getInteger("n_neighbors");
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getNumberArray("_fit_X");
    }

    @Override
    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    @Override
    public List<?> getId() {
        if (!this.containsKey("_id")) {
            int[] shape = this.getFitXShape();
            return SliceUtil.indices((int)0, (int)shape[0]);
        }
        return this.getArray("_id");
    }

    @Override
    public List<? extends Number> getY() {
        return null;
    }

    @Override
    public int[] getYShape() {
        throw new UnsupportedOperationException();
    }
}

