/*
 * Decompiled with CFR 0.152.
 */
package sklearn.multioutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Model;
import org.dmg.pmml.mining.Segmentation;
import org.jpmml.converter.Label;
import org.jpmml.converter.ScalarLabel;
import org.jpmml.converter.ScalarLabelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.python.ClassDictUtil;
import sklearn.Estimator;

public class MultiOutputUtil {
    private MultiOutputUtil() {
    }

    public static <E extends Estimator> Model encodeEstimators(List<E> estimators, Schema schema) {
        if (estimators.size() == 1) {
            Estimator estimator = (Estimator)estimators.get(0);
            return estimator.encode(schema);
        }
        if (estimators.size() >= 2) {
            List scalarLabels = ScalarLabelUtil.toScalarLabels((Label)schema.getLabel());
            ClassDictUtil.checkSize((Collection[])new Collection[]{estimators, scalarLabels});
            ArrayList<Model> models = new ArrayList<Model>();
            for (int i = 0; i < estimators.size(); ++i) {
                Estimator estimator = (Estimator)estimators.get(i);
                ScalarLabel scalarLabel = (ScalarLabel)scalarLabels.get(i);
                Schema segmentSchema = schema.toRelabeledSchema((Label)scalarLabel);
                Model model = estimator.encode(scalarLabel.getName(), segmentSchema);
                models.add(model);
            }
            return MiningModelUtil.createMultiModelChain(models, (Segmentation.MissingPredictionTreatment)Segmentation.MissingPredictionTreatment.CONTINUE);
        }
        throw new IllegalArgumentException();
    }
}

