/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.converter.Schema;
import sklearn.HasDefaultValue;
import sklearn.HasEstimatorEnsemble;
import sklearn.SkLearnRegressor;
import sklearn.ensemble.gradient_boosting.GradientBoostingUtil;
import sklearn.tree.HasTreeOptions;
import sklearn.tree.TreeRegressor;

public class GradientBoostingRegressor
extends SkLearnRegressor
implements HasEstimatorEnsemble<TreeRegressor>,
HasTreeOptions {
    public GradientBoostingRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features")) {
            return this.getInteger("n_features");
        }
        return super.getNumberOfFeatures();
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public MiningModel encodeModel(Schema schema) {
        HasDefaultValue init = this.getInit();
        Number learningRate = this.getLearningRate();
        return GradientBoostingUtil.encodeGradientBoosting(this, init.getDefaultValue(), learningRate, schema);
    }

    public HasDefaultValue getInit() {
        return (HasDefaultValue)this.get("init_", HasDefaultValue.class);
    }

    public Number getLearningRate() {
        return this.getNumber("learning_rate");
    }

    @Override
    public List<? extends TreeRegressor> getEstimators() {
        return this.getArray("estimators_", TreeRegressor.class);
    }
}

