/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import builtins.TypeConstructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.CastFunction;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PythonTypeUtil;
import org.jpmml.python.TypeInfo;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Step;
import sklearn.StepUtil;
import sklearn2pmml.HasPMMLName;

public abstract class Transformer
extends Step
implements HasPMMLName<Transformer> {
    public Transformer(String module, String name) {
        super(module, name);
    }

    public abstract List<Feature> encodeFeatures(List<Feature> var1, SkLearnEncoder var2);

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features_in_")) {
            return this.getInteger("n_features_in_");
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public List<Feature> encode(List<Feature> features, SkLearnEncoder encoder) {
        this.checkVersion();
        this.checkFeatures(features);
        features = this.updateFeatures(features, encoder);
        return this.encodeFeatures(features, encoder);
    }

    public void checkFeatures(List<? extends Feature> features) {
        StepUtil.checkNumberOfFeatures(this, features);
    }

    public List<Feature> updateFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        OpType opType;
        try {
            opType = this.getOpType();
            dataType = this.getDataType();
        }
        catch (UnsupportedOperationException uoe) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>(features.size());
        for (Feature feature : features) {
            if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                feature = this.refineWildcardFeature(wildcardFeature, opType, dataType, encoder);
            }
            result.add(feature);
        }
        return result;
    }

    public WildcardFeature refineWildcardFeature(WildcardFeature wildcardFeature, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        String name = wildcardFeature.getName();
        DataField dataField = encoder.getDataField(name);
        if (dataField == null) {
            throw new IllegalArgumentException("Field " + name + " is undefined");
        }
        if (dataField.requireOpType() != opType || dataField.requireDataType() != dataType) {
            dataField = this.updateDataField(dataField, opType, dataType, encoder);
            wildcardFeature = new WildcardFeature((PMMLEncoder)encoder, dataField);
        }
        return wildcardFeature;
    }

    public DataField updateDataField(DataField dataField, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        String name = dataField.requireName();
        if (encoder.isFrozen(name)) {
            return dataField;
        }
        switch (dataType) {
            case DOUBLE: {
                if (dataField.requireDataType() == DataType.DOUBLE) break;
                dataType = dataField.requireDataType();
            }
        }
        dataField.setOpType(opType).setDataType(dataType);
        return dataField;
    }

    public TypeInfo getOptionalDType(String name, boolean extended) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return this.getDType(name, extended);
    }

    public TypeInfo getDType(final String name, final boolean extended) {
        Object dtype = this.getObject(name);
        CastFunction<TypeInfo> castFunction = new CastFunction<TypeInfo>(TypeInfo.class){

            public TypeInfo apply(Object object) {
                if (object instanceof TypeConstructor) {
                    TypeConstructor typeConstructor = (TypeConstructor)object;
                    return (TypeInfo)typeConstructor.construct();
                }
                if (object instanceof String) {
                    final String string = (String)object;
                    if (extended) {
                        return new TypeInfo(){

                            public DataType getDataType() {
                                return PythonTypeUtil.parseDataType((String)string);
                            }
                        };
                    }
                }
                return (TypeInfo)super.apply(object);
            }

            protected String formatMessage(Object object) {
                return "Attribute (" + ClassDictUtil.formatMember((ClassDict)Transformer.this, (String)name) + ") is not a supported type info";
            }
        };
        return (TypeInfo)castFunction.apply(dtype);
    }

    public String createFieldName(String function, Object ... args) {
        return this.createFieldName(function, Arrays.asList(args));
    }

    public String createFieldName(String function, List<?> args) {
        String pmmlName = this.getPMMLName();
        if (pmmlName != null) {
            return pmmlName;
        }
        return FieldNameUtil.create((String)function, args);
    }

    @Override
    public Transformer setPMMLName(String pmmlName) {
        return (Transformer)super.setPMMLName(pmmlName);
    }
}

