/*
 * Decompiled with CFR 0.152.
 */
package sklearn.tree.visitors;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;

public class TreeModelFlattener
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;

    public void enterNode(Node node) {
        if (node.hasNodes()) {
            List children = node.getNodes();
            block0: while (true) {
                ListIterator<Node> childIt = children.listIterator();
                while (childIt.hasNext()) {
                    Node child = (Node)childIt.next();
                    Iterator<Node> grandChildIt = TreeModelFlattener.getChildren(child);
                    if (grandChildIt == null) continue;
                    childIt.remove();
                    while (grandChildIt.hasNext()) {
                        Node grandChild = grandChildIt.next();
                        grandChildIt.remove();
                        childIt.add(grandChild);
                    }
                    childIt.add(child);
                    continue block0;
                }
                break;
            }
        }
    }

    public void exitNode(Node node) {
        Predicate predicate = node.requirePredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            List parentChildren = parentNode.getNodes();
            if (parentChildren.size() != 1) {
                return;
            }
            boolean success = parentChildren.remove(node);
            if (!success) {
                throw new UnsupportedElementException((PMMLObject)parentNode);
            }
            if (this.miningFunction == MiningFunction.REGRESSION) {
                parentNode.setScore(null);
                TreeModelFlattener.initScore((Node)parentNode, (Node)node);
            } else if (this.miningFunction == MiningFunction.CLASSIFICATION) {
                TreeModelFlattener.initScoreDistribution((Node)parentNode, (Node)node);
            }
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        super.enterTreeModel(treeModel);
        treeModel.setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        MiningFunction miningFunction = treeModel.requireMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)miningFunction);
            }
        }
        this.miningFunction = miningFunction;
    }

    public void exitTreeModel(TreeModel treeModel) {
        super.exitTreeModel(treeModel);
        this.miningFunction = null;
    }

    private static Iterator<Node> getChildren(Node node) {
        Predicate predicate = node.requirePredicate();
        if (!(predicate instanceof SimplePredicate)) {
            return null;
        }
        SimplePredicate simplePredicate = (SimplePredicate)predicate;
        if (!TreeModelFlattener.hasOperator((Predicate)simplePredicate, (SimplePredicate.Operator)SimplePredicate.Operator.LESS_OR_EQUAL)) {
            return null;
        }
        if (node.hasNodes()) {
            Node child;
            Predicate childPredicate;
            List children = node.getNodes();
            int endPos = 0;
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && TreeModelFlattener.hasFieldReference((Predicate)(childPredicate = (child = (Node)iterator.next()).requirePredicate()), (String)simplePredicate.requireField()) && TreeModelFlattener.hasOperator((Predicate)childPredicate, (SimplePredicate.Operator)simplePredicate.requireOperator())) {
                ++endPos;
            }
            if (endPos > 0) {
                return children.subList(0, endPos).iterator();
            }
            return null;
        }
        return null;
    }
}

