/*
 * Decompiled with CFR 0.152.
 */
package sklearn.svm;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.LinearKernel;
import org.dmg.pmml.support_vector_machine.PolynomialKernel;
import org.dmg.pmml.support_vector_machine.RadialBasisKernel;
import org.dmg.pmml.support_vector_machine.SigmoidKernel;

public class SupportVectorMachineUtil {
    private SupportVectorMachineUtil() {
    }

    public static List<String> formatIds(List<Integer> values) {
        Function<Integer, String> function = new Function<Integer, String>(){

            public String apply(Integer value) {
                return value.toString();
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public static Kernel createKernel(String kernel, Number degree, Number gamma, Number coef0) {
        switch (kernel) {
            case "linear": {
                return new LinearKernel();
            }
            case "poly": {
                return new PolynomialKernel().setGamma(gamma).setCoef0(coef0).setDegree(degree);
            }
            case "rbf": {
                return new RadialBasisKernel().setGamma(gamma);
            }
            case "sigmoid": {
                return new SigmoidKernel().setGamma(gamma).setCoef0(coef0);
            }
        }
        throw new IllegalArgumentException(kernel);
    }
}

