/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import sklearn.Classifier;
import sklearn.neighbors.HasNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsClassifier
extends Classifier
implements HasNeighbors,
HasTrainingData {
    public KNeighborsClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.CLASSIFICATION, numberOfInstances, numberOfFeatures, schema).setCategoricalScoringMethod(NearestNeighborModel.CategoricalScoringMethod.MAJORITY_VOTE);
        return nearestNeighborModel;
    }

    @Override
    public String getMetric() {
        return this.getString("metric");
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.getInteger("n_neighbors");
    }

    @Override
    public int getP() {
        return this.getInteger("p");
    }

    @Override
    public String getWeights() {
        return this.getString("weights");
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getNumberArray("_fit_X");
    }

    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    @Override
    public List<?> getY() {
        List y = this.getNumberArray("_y");
        Function<Number, Object> function = new Function<Number, Object>(){
            private List<?> classes;
            {
                this.classes = KNeighborsClassifier.this.getClasses();
            }

            public Object apply(Number number) {
                int index = ValueUtil.asInt((Number)number);
                return this.classes.get(index);
            }
        };
        return Lists.transform((List)y, (Function)function);
    }
}

