
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Since;

@XmlType(name = "RESULT-FEATURE", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum ResultFeature
    implements StringValue<ResultFeature>
{

    @XmlEnumValue("predictedValue")
    @JsonProperty("predictedValue")
    PREDICTED_VALUE("predictedValue"),
    @XmlEnumValue("predictedDisplayValue")
    @JsonProperty("predictedDisplayValue")
    PREDICTED_DISPLAY_VALUE("predictedDisplayValue"),
    @XmlEnumValue("transformedValue")
    @JsonProperty("transformedValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    TRANSFORMED_VALUE("transformedValue"),
    @XmlEnumValue("decision")
    @JsonProperty("decision")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    DECISION("decision"),
    @XmlEnumValue("probability")
    @JsonProperty("probability")
    PROBABILITY("probability"),
    @XmlEnumValue("affinity")
    @JsonProperty("affinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    AFFINITY("affinity"),
    @XmlEnumValue("residual")
    @JsonProperty("residual")
    RESIDUAL("residual"),
    @XmlEnumValue("standardError")
    @JsonProperty("standardError")
    STANDARD_ERROR("standardError"),
    @XmlEnumValue("standardDeviation")
    @JsonProperty("standardDeviation")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    STANDARD_DEVIATION("standardDeviation"),
    @XmlEnumValue("clusterId")
    @JsonProperty("clusterId")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    CLUSTER_ID("clusterId"),
    @XmlEnumValue("clusterAffinity")
    @JsonProperty("clusterAffinity")
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    CLUSTER_AFFINITY("clusterAffinity"),
    @XmlEnumValue("entityId")
    @JsonProperty("entityId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    ENTITY_ID("entityId"),
    @XmlEnumValue("entityAffinity")
    @JsonProperty("entityAffinity")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_1))
    ENTITY_AFFINITY("entityAffinity"),
    @XmlEnumValue("warning")
    @JsonProperty("warning")
    WARNING("warning"),
    @XmlEnumValue("ruleValue")
    @JsonProperty("ruleValue")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    RULE_VALUE("ruleValue"),
    @XmlEnumValue("reasonCode")
    @JsonProperty("reasonCode")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    REASON_CODE("reasonCode"),
    @XmlEnumValue("antecedent")
    @JsonProperty("antecedent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    ANTECEDENT("antecedent"),
    @XmlEnumValue("consequent")
    @JsonProperty("consequent")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    CONSEQUENT("consequent"),
    @XmlEnumValue("rule")
    @JsonProperty("rule")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    RULE("rule"),
    @XmlEnumValue("ruleId")
    @JsonProperty("ruleId")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @org.jpmml.model.annotations.Deprecated((org.dmg.pmml.Version.PMML_4_2))
    RULE_ID("ruleId"),
    @XmlEnumValue("confidence")
    @JsonProperty("confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    CONFIDENCE("confidence"),
    @XmlEnumValue("support")
    @JsonProperty("support")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    SUPPORT("support"),
    @XmlEnumValue("lift")
    @JsonProperty("lift")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    LIFT("lift"),
    @XmlEnumValue("leverage")
    @JsonProperty("leverage")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    LEVERAGE("leverage"),
    @XmlEnumValue("confidenceIntervalLower")
    @JsonProperty("confidenceIntervalLower")
    CONFIDENCE_INTERVAL_LOWER("confidenceIntervalLower"),
    @XmlEnumValue("confidenceIntervalUpper")
    @JsonProperty("confidenceIntervalUpper")
    CONFIDENCE_INTERVAL_UPPER("confidenceIntervalUpper"),
    @XmlEnumValue("x-report")
    @JsonProperty("x-report")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.XPMML))
    @Since(("1.3.8"))
    REPORT("x-report");
    private final String value;

    ResultFeature(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static ResultFeature fromValue(String v) {
        for (ResultFeature c: ResultFeature.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
