
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
@JsonRootName("PredictiveModelQuality")
@JsonPropertyOrder({
    "targetField",
    "dataName",
    "dataUsage",
    "meanError",
    "meanAbsoluteError",
    "meanSquaredError",
    "rootMeanSquaredError",
    "rSquared",
    "adjRSquared",
    "sumSquaredError",
    "sumSquaredRegression",
    "numOfRecords",
    "numOfRecordsWeighted",
    "numOfPredictors",
    "degreesOfFreedom",
    "fStatistic",
    "aic",
    "bic",
    "aiCc",
    "accuracy",
    "auc",
    "precision",
    "recall",
    "specificity",
    "f1",
    "f2",
    "fhalf",
    "extensions",
    "confusionMatrix",
    "liftDatas",
    "roc"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class PredictiveModelQuality
    extends ModelQuality
    implements HasExtensions<PredictiveModelQuality> , HasTargetFieldReference<PredictiveModelQuality>
{

    @XmlAttribute(name = "targetField", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("targetField")
    private String targetField;
    @XmlAttribute(name = "dataName")
    @JsonProperty("dataName")
    private String dataName;
    @XmlAttribute(name = "dataUsage")
    @JsonProperty("dataUsage")
    private PredictiveModelQuality.DataUsage dataUsage;
    @XmlAttribute(name = "meanError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanError")
    private Number meanError;
    @XmlAttribute(name = "meanAbsoluteError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanAbsoluteError")
    private Number meanAbsoluteError;
    @XmlAttribute(name = "meanSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanSquaredError")
    private Number meanSquaredError;
    @XmlAttribute(name = "rootMeanSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("rootMeanSquaredError")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number rootMeanSquaredError;
    @XmlAttribute(name = "r-squared")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("r-squared")
    private Number rSquared;
    @XmlAttribute(name = "adj-r-squared")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("adj-r-squared")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number adjRSquared;
    @XmlAttribute(name = "sumSquaredError")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("sumSquaredError")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number sumSquaredError;
    @XmlAttribute(name = "sumSquaredRegression")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("sumSquaredRegression")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number sumSquaredRegression;
    @XmlAttribute(name = "numOfRecords")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("numOfRecords")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number numOfRecords;
    @XmlAttribute(name = "numOfRecordsWeighted")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("numOfRecordsWeighted")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number numOfRecordsWeighted;
    @XmlAttribute(name = "numOfPredictors")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("numOfPredictors")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number numOfPredictors;
    @XmlAttribute(name = "degreesOfFreedom")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("degreesOfFreedom")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number degreesOfFreedom;
    @XmlAttribute(name = "fStatistic")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("fStatistic")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number fStatistic;
    @XmlAttribute(name = "AIC")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("AIC")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number aic;
    @XmlAttribute(name = "BIC")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("BIC")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number bic;
    @XmlAttribute(name = "AICc")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("AICc")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Number aiCc;
    @XmlAttribute(name = "accuracy")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("accuracy")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number accuracy;
    @XmlAttribute(name = "AUC")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("AUC")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number auc;
    @XmlAttribute(name = "precision")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("precision")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number precision;
    @XmlAttribute(name = "recall")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("recall")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number recall;
    @XmlAttribute(name = "specificity")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("specificity")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number specificity;
    @XmlAttribute(name = "F1")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("F1")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number f1;
    @XmlAttribute(name = "F2")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("F2")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number f2;
    @XmlAttribute(name = "Fhalf")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("Fhalf")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_4), removable = (true))
    private Number fhalf;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ConfusionMatrix", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ConfusionMatrix")
    private ConfusionMatrix confusionMatrix;
    @XmlElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LiftData")
    private List<LiftData> liftDatas;
    @XmlElement(name = "ROC", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ROC")
    private ROC roc;
    private final static long serialVersionUID = 67371270L;

    public PredictiveModelQuality() {
    }

    @ValueConstructor
    public PredictiveModelQuality(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
    }

    @AlternateValueConstructor
    public PredictiveModelQuality(Field<?> targetField) {
        this(((targetField!= null)?targetField.requireName():null));
    }

    public String requireTargetField() {
        if (this.targetField == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PREDICTIVEMODELQUALITY_TARGETFIELD);
        }
        return this.targetField;
    }

    @Override
    public String getTargetField() {
        return targetField;
    }

    @Override
    public PredictiveModelQuality setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public String getDataName() {
        return dataName;
    }

    @Override
    public PredictiveModelQuality setDataName(
        @org.jpmml.model.annotations.Property("dataName")
        String dataName) {
        this.dataName = dataName;
        return this;
    }

    public PredictiveModelQuality.DataUsage getDataUsage() {
        if (dataUsage == null) {
            return PredictiveModelQuality.DataUsage.TRAINING;
        } else {
            return dataUsage;
        }
    }

    public PredictiveModelQuality setDataUsage(
        @org.jpmml.model.annotations.Property("dataUsage")
        PredictiveModelQuality.DataUsage dataUsage) {
        this.dataUsage = dataUsage;
        return this;
    }

    public Number getMeanError() {
        return meanError;
    }

    public PredictiveModelQuality setMeanError(
        @org.jpmml.model.annotations.Property("meanError")
        Number meanError) {
        this.meanError = meanError;
        return this;
    }

    public Number getMeanAbsoluteError() {
        return meanAbsoluteError;
    }

    public PredictiveModelQuality setMeanAbsoluteError(
        @org.jpmml.model.annotations.Property("meanAbsoluteError")
        Number meanAbsoluteError) {
        this.meanAbsoluteError = meanAbsoluteError;
        return this;
    }

    public Number getMeanSquaredError() {
        return meanSquaredError;
    }

    public PredictiveModelQuality setMeanSquaredError(
        @org.jpmml.model.annotations.Property("meanSquaredError")
        Number meanSquaredError) {
        this.meanSquaredError = meanSquaredError;
        return this;
    }

    public Number getRootMeanSquaredError() {
        return rootMeanSquaredError;
    }

    public PredictiveModelQuality setRootMeanSquaredError(
        @org.jpmml.model.annotations.Property("rootMeanSquaredError")
        Number rootMeanSquaredError) {
        this.rootMeanSquaredError = rootMeanSquaredError;
        return this;
    }

    public Number getRSquared() {
        return rSquared;
    }

    public PredictiveModelQuality setRSquared(
        @org.jpmml.model.annotations.Property("rSquared")
        Number rSquared) {
        this.rSquared = rSquared;
        return this;
    }

    public Number getAdjRSquared() {
        return adjRSquared;
    }

    public PredictiveModelQuality setAdjRSquared(
        @org.jpmml.model.annotations.Property("adjRSquared")
        Number adjRSquared) {
        this.adjRSquared = adjRSquared;
        return this;
    }

    public Number getSumSquaredError() {
        return sumSquaredError;
    }

    public PredictiveModelQuality setSumSquaredError(
        @org.jpmml.model.annotations.Property("sumSquaredError")
        Number sumSquaredError) {
        this.sumSquaredError = sumSquaredError;
        return this;
    }

    public Number getSumSquaredRegression() {
        return sumSquaredRegression;
    }

    public PredictiveModelQuality setSumSquaredRegression(
        @org.jpmml.model.annotations.Property("sumSquaredRegression")
        Number sumSquaredRegression) {
        this.sumSquaredRegression = sumSquaredRegression;
        return this;
    }

    public Number getNumOfRecords() {
        return numOfRecords;
    }

    public PredictiveModelQuality setNumOfRecords(
        @org.jpmml.model.annotations.Property("numOfRecords")
        Number numOfRecords) {
        this.numOfRecords = numOfRecords;
        return this;
    }

    public Number getNumOfRecordsWeighted() {
        return numOfRecordsWeighted;
    }

    public PredictiveModelQuality setNumOfRecordsWeighted(
        @org.jpmml.model.annotations.Property("numOfRecordsWeighted")
        Number numOfRecordsWeighted) {
        this.numOfRecordsWeighted = numOfRecordsWeighted;
        return this;
    }

    public Number getNumOfPredictors() {
        return numOfPredictors;
    }

    public PredictiveModelQuality setNumOfPredictors(
        @org.jpmml.model.annotations.Property("numOfPredictors")
        Number numOfPredictors) {
        this.numOfPredictors = numOfPredictors;
        return this;
    }

    public Number getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    public PredictiveModelQuality setDegreesOfFreedom(
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        Number degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    public Number getFStatistic() {
        return fStatistic;
    }

    public PredictiveModelQuality setFStatistic(
        @org.jpmml.model.annotations.Property("fStatistic")
        Number fStatistic) {
        this.fStatistic = fStatistic;
        return this;
    }

    public Number getAIC() {
        return aic;
    }

    public PredictiveModelQuality setAIC(
        @org.jpmml.model.annotations.Property("aic")
        Number aic) {
        this.aic = aic;
        return this;
    }

    public Number getBIC() {
        return bic;
    }

    public PredictiveModelQuality setBIC(
        @org.jpmml.model.annotations.Property("bic")
        Number bic) {
        this.bic = bic;
        return this;
    }

    public Number getAICc() {
        return aiCc;
    }

    public PredictiveModelQuality setAICc(
        @org.jpmml.model.annotations.Property("aiCc")
        Number aiCc) {
        this.aiCc = aiCc;
        return this;
    }

    public Number getAccuracy() {
        return accuracy;
    }

    public PredictiveModelQuality setAccuracy(
        @org.jpmml.model.annotations.Property("accuracy")
        Number accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public Number getAUC() {
        return auc;
    }

    public PredictiveModelQuality setAUC(
        @org.jpmml.model.annotations.Property("auc")
        Number auc) {
        this.auc = auc;
        return this;
    }

    public Number getPrecision() {
        return precision;
    }

    public PredictiveModelQuality setPrecision(
        @org.jpmml.model.annotations.Property("precision")
        Number precision) {
        this.precision = precision;
        return this;
    }

    public Number getRecall() {
        return recall;
    }

    public PredictiveModelQuality setRecall(
        @org.jpmml.model.annotations.Property("recall")
        Number recall) {
        this.recall = recall;
        return this;
    }

    public Number getSpecificity() {
        return specificity;
    }

    public PredictiveModelQuality setSpecificity(
        @org.jpmml.model.annotations.Property("specificity")
        Number specificity) {
        this.specificity = specificity;
        return this;
    }

    public Number getF1() {
        return f1;
    }

    public PredictiveModelQuality setF1(
        @org.jpmml.model.annotations.Property("f1")
        Number f1) {
        this.f1 = f1;
        return this;
    }

    public Number getF2() {
        return f2;
    }

    public PredictiveModelQuality setF2(
        @org.jpmml.model.annotations.Property("f2")
        Number f2) {
        this.f2 = f2;
        return this;
    }

    public Number getFhalf() {
        return fhalf;
    }

    public PredictiveModelQuality setFhalf(
        @org.jpmml.model.annotations.Property("fhalf")
        Number fhalf) {
        this.fhalf = fhalf;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictiveModelQuality addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ConfusionMatrix getConfusionMatrix() {
        return confusionMatrix;
    }

    public PredictiveModelQuality setConfusionMatrix(
        @org.jpmml.model.annotations.Property("confusionMatrix")
        ConfusionMatrix confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
        return this;
    }

    public boolean hasLiftDatas() {
        return ((this.liftDatas!= null)&&(!this.liftDatas.isEmpty()));
    }

    public List<LiftData> getLiftDatas() {
        if (liftDatas == null) {
            liftDatas = new ArrayList<LiftData>();
        }
        return this.liftDatas;
    }

    public PredictiveModelQuality addLiftDatas(LiftData... liftDatas) {
        getLiftDatas().addAll(Arrays.asList(liftDatas));
        return this;
    }

    public ROC getROC() {
        return roc;
    }

    public PredictiveModelQuality setROC(
        @org.jpmml.model.annotations.Property("roc")
        ROC roc) {
        this.roc = roc;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getConfusionMatrix());
            }
            if ((status == VisitorAction.CONTINUE)&&hasLiftDatas()) {
                status = PMMLObject.traverse(visitor, getLiftDatas());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getROC());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum DataUsage
        implements StringValue<PredictiveModelQuality.DataUsage>
    {

        @XmlEnumValue("training")
        @JsonProperty("training")
        TRAINING("training"),
        @XmlEnumValue("test")
        @JsonProperty("test")
        TEST("test"),
        @XmlEnumValue("validation")
        @JsonProperty("validation")
        VALIDATION("validation");
        private final String value;

        DataUsage(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static PredictiveModelQuality.DataUsage fromValue(String v) {
            for (PredictiveModelQuality.DataUsage c: PredictiveModelQuality.DataUsage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
