
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "liftGraph"
})
@JsonRootName("OptimumLiftGraph")
@JsonPropertyOrder({
    "extensions",
    "liftGraph"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class OptimumLiftGraph
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<OptimumLiftGraph>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "LiftGraph", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("LiftGraph")
    private LiftGraph liftGraph;
    private final static long serialVersionUID = 67371270L;

    public OptimumLiftGraph() {
    }

    @ValueConstructor
    public OptimumLiftGraph(
        @org.jpmml.model.annotations.Property("liftGraph")
        LiftGraph liftGraph) {
        this.liftGraph = liftGraph;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public OptimumLiftGraph addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public LiftGraph requireLiftGraph() {
        if (this.liftGraph == null) {
            throw new MissingElementException(this, PMMLElements.OPTIMUMLIFTGRAPH_LIFTGRAPH);
        }
        return this.liftGraph;
    }

    public LiftGraph getLiftGraph() {
        return liftGraph;
    }

    public OptimumLiftGraph setLiftGraph(
        @org.jpmml.model.annotations.Property("liftGraph")
        LiftGraph liftGraph) {
        this.liftGraph = liftGraph;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getLiftGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
