
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Optional;

@XmlRootElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningFields"
})
@JsonRootName("MiningSchema")
@JsonPropertyOrder({
    "extensions",
    "miningFields"
})
public class MiningSchema
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<MiningSchema>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("MiningField")
    @Optional((org.dmg.pmml.Version.XPMML))
    private List<MiningField> miningFields;
    private final static long serialVersionUID = 67371270L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningSchema addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasMiningFields() {
        return ((this.miningFields!= null)&&(!this.miningFields.isEmpty()));
    }

    public List<MiningField> getMiningFields() {
        if (miningFields == null) {
            miningFields = new ArrayList<MiningField>();
        }
        return this.miningFields;
    }

    public MiningSchema addMiningFields(MiningField... miningFields) {
        getMiningFields().addAll(Arrays.asList(miningFields));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMiningFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMiningFields());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
