
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "discretizeBins"
})
@JsonRootName("Discretize")
@JsonPropertyOrder({
    "field",
    "mapMissingTo",
    "defaultValue",
    "dataType",
    "extensions",
    "discretizeBins"
})
public class Discretize
    extends Expression
    implements HasDataType<Discretize> , HasDefaultValue<Discretize, Object> , HasExtensions<Discretize> , HasFieldReference<Discretize> , HasMapMissingTo<Discretize, Object>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "mapMissingTo")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("mapMissingTo")
    private Object mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @XmlAttribute(name = "dataType")
    @JsonProperty("dataType")
    @Added((org.dmg.pmml.Version.PMML_3_1))
    private DataType dataType;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DiscretizeBin", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DiscretizeBin")
    @Optional((org.dmg.pmml.Version.PMML_3_2))
    private List<DiscretizeBin> discretizeBins;
    private final static long serialVersionUID = 67371270L;

    public Discretize() {
    }

    @ValueConstructor
    public Discretize(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public Discretize(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DISCRETIZE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public Discretize setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public Object getMapMissingTo() {
        return mapMissingTo;
    }

    @Override
    public Discretize setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Object mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    @Override
    public Discretize setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public Discretize setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Discretize addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDiscretizeBins() {
        return ((this.discretizeBins!= null)&&(!this.discretizeBins.isEmpty()));
    }

    public List<DiscretizeBin> getDiscretizeBins() {
        if (discretizeBins == null) {
            discretizeBins = new ArrayList<DiscretizeBin>();
        }
        return this.discretizeBins;
    }

    public Discretize addDiscretizeBins(DiscretizeBin... discretizeBins) {
        getDiscretizeBins().addAll(Arrays.asList(discretizeBins));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDiscretizeBins()) {
                status = PMMLObject.traverse(visitor, getDiscretizeBins());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
