/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.support_vector_machine;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Array;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.RealSparseArray;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.support_vector_machine.Coefficient;
import org.dmg.pmml.support_vector_machine.Coefficients;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.dmg.pmml.support_vector_machine.PMMLAttributes;
import org.dmg.pmml.support_vector_machine.PMMLElements;
import org.dmg.pmml.support_vector_machine.SupportVector;
import org.dmg.pmml.support_vector_machine.SupportVectorMachine;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.support_vector_machine.SupportVectors;
import org.dmg.pmml.support_vector_machine.VectorDictionary;
import org.dmg.pmml.support_vector_machine.VectorFields;
import org.dmg.pmml.support_vector_machine.VectorInstance;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvalidElementListException;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MisplacedElementException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.SparseArrayUtil;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.support_vector_machine.DistanceDistribution;
import org.jpmml.evaluator.support_vector_machine.KernelUtil;
import org.jpmml.evaluator.support_vector_machine.VoteDistribution;
import org.jpmml.evaluator.support_vector_machine.VoteMap;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.XPathUtil;

public class SupportVectorMachineModelEvaluator
extends ModelEvaluator<SupportVectorMachineModel> {
    private transient Map<String, Object> vectorMap = null;
    private static final LoadingCache<SupportVectorMachineModel, Map<String, Object>> vectorCache = CacheUtil.buildLoadingCache(new CacheLoader<SupportVectorMachineModel, Map<String, Object>>(){

        public Map<String, Object> load(SupportVectorMachineModel supportVectorMachineModel) {
            return ImmutableMap.copyOf((Map)SupportVectorMachineModelEvaluator.parseVectorDictionary(supportVectorMachineModel));
        }
    });

    public SupportVectorMachineModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, SupportVectorMachineModel.class));
    }

    public SupportVectorMachineModelEvaluator(PMML pmml, SupportVectorMachineModel supportVectorMachineModel) {
        super(pmml, supportVectorMachineModel);
        boolean maxWins = supportVectorMachineModel.isMaxWins();
        if (maxWins) {
            throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, PMMLAttributes.SUPPORTVECTORMACHINEMODEL_MAXWINS, maxWins);
        }
        SupportVectorMachineModel.Representation representation = supportVectorMachineModel.getRepresentation();
        switch (representation) {
            case SUPPORT_VECTORS: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)representation);
            }
        }
        VectorDictionary vectorDictionary = supportVectorMachineModel.getVectorDictionary();
        if (vectorDictionary == null) {
            throw new MissingElementException((PMMLObject)supportVectorMachineModel, PMMLElements.SUPPORTVECTORMACHINEMODEL_VECTORDICTIONARY);
        }
        VectorFields vectorFields = vectorDictionary.getVectorFields();
        if (vectorFields == null) {
            throw new MissingElementException((PMMLObject)vectorDictionary, PMMLElements.VECTORDICTIONARY_VECTORFIELDS);
        }
        if (!supportVectorMachineModel.hasSupportVectorMachines()) {
            throw new MissingElementException((PMMLObject)supportVectorMachineModel, PMMLElements.SUPPORTVECTORMACHINEMODEL_SUPPORTVECTORMACHINES);
        }
    }

    @Override
    public String getSummary() {
        return "Support vector machine";
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        if (supportVectorMachines.size() != 1) {
            throw new InvalidElementListException(supportVectorMachines);
        }
        SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
        Object input = this.createInput(context);
        Value<V> result = this.evaluateSupportVectorMachine(valueFactory, supportVectorMachine, input);
        return TargetUtil.evaluateRegression(this.getTargetField(), result);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <V extends Number> Map<FieldName, ? extends Classification<?, V>> evaluateClassification(final ValueFactory<V> valueFactory, EvaluationContext context) {
        VoteMap values;
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        Object alternateBinaryTargetCategory = supportVectorMachineModel.getAlternateBinaryTargetCategory();
        SupportVectorMachineModel.ClassificationMethod classificationMethod = this.getClassificationMethod();
        switch (classificationMethod) {
            case ONE_AGAINST_ALL: {
                values = new ValueMap(2 * supportVectorMachines.size());
                break;
            }
            case ONE_AGAINST_ONE: {
                values = new VoteMap<Object, V>(2 * supportVectorMachines.size()){

                    @Override
                    public ValueFactory<V> getValueFactory() {
                        return valueFactory;
                    }
                };
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)classificationMethod);
            }
        }
        Object input = this.createInput(context);
        for (SupportVectorMachine supportVectorMachine : supportVectorMachines) {
            Object targetCategory = supportVectorMachine.getTargetCategory();
            if (targetCategory == null) {
                throw new MissingAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_TARGETCATEGORY);
            }
            Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
            Value<V> value = this.evaluateSupportVectorMachine(valueFactory, supportVectorMachine, input);
            switch (classificationMethod) {
                case ONE_AGAINST_ALL: {
                    if (alternateTargetCategory != null) {
                        throw new MisplacedAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY, alternateTargetCategory);
                    }
                    values.put(targetCategory, value);
                    break;
                }
                case ONE_AGAINST_ONE: {
                    Object label;
                    if (alternateBinaryTargetCategory != null) {
                        if (alternateTargetCategory != null) {
                            throw new MisplacedAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY, alternateTargetCategory);
                        }
                        value.round();
                        if (value.isZero()) {
                            label = alternateBinaryTargetCategory;
                        } else {
                            if (!value.isOne()) throw new EvaluationException("Expected " + PMMLException.formatValue(Numbers.DOUBLE_ZERO) + " or " + PMMLException.formatValue(Numbers.DOUBLE_ONE) + ", got " + PMMLException.formatValue(value.getValue()));
                            label = targetCategory;
                        }
                    } else {
                        if (alternateTargetCategory == null) {
                            throw new MissingAttributeException((PMMLObject)supportVectorMachine, PMMLAttributes.SUPPORTVECTORMACHINE_ALTERNATETARGETCATEGORY);
                        }
                        Number threshold = supportVectorMachine.getThreshold();
                        if (threshold == null) {
                            threshold = supportVectorMachineModel.getThreshold();
                        }
                        label = value.compareTo(threshold) < 0 ? targetCategory : alternateTargetCategory;
                    }
                    VoteMap votes = values;
                    votes.increment(label);
                    break;
                }
            }
        }
        switch (classificationMethod) {
            case ONE_AGAINST_ALL: {
                void var9_12;
                DistanceDistribution distanceDistribution = new DistanceDistribution(values);
                return TargetUtil.evaluateClassification(this.getTargetField(), var9_12);
            }
            case ONE_AGAINST_ONE: {
                void var9_12;
                VoteDistribution voteDistribution = new VoteDistribution(values);
                return TargetUtil.evaluateClassification(this.getTargetField(), var9_12);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)classificationMethod);
            }
        }
    }

    private <V extends Number> Value<V> evaluateSupportVectorMachine(ValueFactory<V> valueFactory, SupportVectorMachine supportVectorMachine, Object input) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        Value<V> result = valueFactory.newValue();
        Kernel kernel = supportVectorMachineModel.getKernel();
        if (kernel == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(supportVectorMachineModel.getClass()) + "/<Kernel>"), (PMMLObject)supportVectorMachine);
        }
        Coefficients coefficients = supportVectorMachine.getCoefficients();
        Iterator coefficientIt = coefficients.iterator();
        SupportVectors supportVectors = supportVectorMachine.getSupportVectors();
        Iterator supportVectorIt = supportVectors.iterator();
        Map<String, Object> vectorMap = this.getVectorMap();
        while (coefficientIt.hasNext() && supportVectorIt.hasNext()) {
            Coefficient coefficient = (Coefficient)coefficientIt.next();
            SupportVector supportVector = (SupportVector)supportVectorIt.next();
            String vectorId = supportVector.getVectorId();
            if (vectorId == null) {
                throw new MissingAttributeException((PMMLObject)supportVector, PMMLAttributes.SUPPORTVECTOR_VECTORID);
            }
            Object vector = vectorMap.get(vectorId);
            if (vector == null) {
                throw new InvalidAttributeException((PMMLObject)supportVector, PMMLAttributes.SUPPORTVECTOR_VECTORID, vectorId);
            }
            Value<V> value = KernelUtil.evaluate(kernel, valueFactory, input, vector);
            result.add(coefficient.getValue(), (Number)value.getValue());
        }
        if (coefficientIt.hasNext() || supportVectorIt.hasNext()) {
            throw new InvalidElementException((PMMLObject)supportVectorMachine);
        }
        result.add(coefficients.getAbsoluteValue());
        return result;
    }

    private SupportVectorMachineModel.ClassificationMethod getClassificationMethod() {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        SupportVectorMachineModel.ClassificationMethod classificationMethod = (SupportVectorMachineModel.ClassificationMethod)ReflectionUtil.getFieldValue((Field)PMMLAttributes.SUPPORTVECTORMACHINEMODEL_CLASSIFICATIONMETHOD, (Object)supportVectorMachineModel);
        if (classificationMethod != null) {
            return classificationMethod;
        }
        List supportVectorMachines = supportVectorMachineModel.getSupportVectorMachines();
        Object alternateBinaryTargetCategory = supportVectorMachineModel.getAlternateBinaryTargetCategory();
        if (alternateBinaryTargetCategory != null) {
            if (supportVectorMachines.size() == 1) {
                SupportVectorMachine supportVectorMachine = (SupportVectorMachine)supportVectorMachines.get(0);
                Object targetCategory = supportVectorMachine.getTargetCategory();
                if (targetCategory != null) {
                    return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                }
                throw new InvalidElementException((PMMLObject)supportVectorMachine);
            }
            throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
        }
        Iterator iterator = supportVectorMachines.iterator();
        if (iterator.hasNext()) {
            SupportVectorMachine supportVectorMachine = (SupportVectorMachine)iterator.next();
            Object targetCategory = supportVectorMachine.getTargetCategory();
            Object alternateTargetCategory = supportVectorMachine.getAlternateTargetCategory();
            if (targetCategory != null) {
                if (alternateTargetCategory != null) {
                    return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ONE;
                }
                return SupportVectorMachineModel.ClassificationMethod.ONE_AGAINST_ALL;
            }
            throw new InvalidElementException((PMMLObject)supportVectorMachine);
        }
        throw new InvalidElementException((PMMLObject)supportVectorMachineModel);
    }

    private Object createInput(EvaluationContext context) {
        SupportVectorMachineModel supportVectorMachineModel = (SupportVectorMachineModel)this.getModel();
        VectorDictionary vectorDictionary = supportVectorMachineModel.getVectorDictionary();
        VectorFields vectorFields = vectorDictionary.getVectorFields();
        List content = vectorFields.getContent();
        ArrayList<Number> result = new ArrayList<Number>(content.size());
        for (int i = 0; i < content.size(); ++i) {
            FieldValue value;
            FieldName name;
            PMMLObject object = (PMMLObject)content.get(i);
            if (object instanceof FieldRef) {
                FieldRef fieldRef = (FieldRef)object;
                name = fieldRef.getField();
                value = ExpressionUtil.evaluate((Expression)fieldRef, context);
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingValueException(name, (PMMLObject)vectorFields);
                }
                result.add(value.asNumber());
                continue;
            }
            if (object instanceof CategoricalPredictor) {
                CategoricalPredictor categoricalPredictor = (CategoricalPredictor)object;
                name = categoricalPredictor.getName();
                if (name == null) {
                    throw new MissingAttributeException((PMMLObject)categoricalPredictor, org.dmg.pmml.regression.PMMLAttributes.CATEGORICALPREDICTOR_FIELD);
                }
                value = context.evaluate(name);
                if (FieldValueUtil.isMissing(value)) {
                    throw new MissingValueException(name, (PMMLObject)categoricalPredictor);
                }
                Number coefficient = categoricalPredictor.getCoefficient();
                if (coefficient != null && coefficient.doubleValue() != 1.0) {
                    throw new InvalidAttributeException((PMMLObject)categoricalPredictor, org.dmg.pmml.regression.PMMLAttributes.CATEGORICALPREDICTOR_COEFFICIENT, coefficient);
                }
                boolean equals = value.equals((HasValue<?>)categoricalPredictor);
                result.add(equals ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO);
                continue;
            }
            throw new MisplacedElementException(object);
        }
        return SupportVectorMachineModelEvaluator.toArray(supportVectorMachineModel, result);
    }

    private Map<String, Object> getVectorMap() {
        if (this.vectorMap == null) {
            this.vectorMap = this.getValue(vectorCache);
        }
        return this.vectorMap;
    }

    private static Map<String, Object> parseVectorDictionary(SupportVectorMachineModel supportVectorMachineModel) {
        VectorDictionary vectorDictionary = supportVectorMachineModel.getVectorDictionary();
        VectorFields vectorFields = vectorDictionary.getVectorFields();
        List content = vectorFields.getContent();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        List vectorInstances = vectorDictionary.getVectorInstances();
        for (VectorInstance vectorInstance : vectorInstances) {
            List<Number> values;
            String id = vectorInstance.getId();
            if (id == null) {
                throw new MissingAttributeException((PMMLObject)vectorInstance, PMMLAttributes.VECTORINSTANCE_ID);
            }
            Array array = vectorInstance.getArray();
            RealSparseArray sparseArray = vectorInstance.getRealSparseArray();
            if (array != null && sparseArray == null) {
                values = ArrayUtil.asNumberList(array);
            } else if (array == null && sparseArray != null) {
                values = SparseArrayUtil.asNumberList(sparseArray);
            } else {
                throw new InvalidElementException((PMMLObject)vectorInstance);
            }
            if (content.size() != values.size()) {
                throw new InvalidElementException((PMMLObject)vectorInstance);
            }
            Object vector = SupportVectorMachineModelEvaluator.toArray(supportVectorMachineModel, values);
            result.put(id, vector);
        }
        return result;
    }

    private static Object toArray(SupportVectorMachineModel supportVectorMachineModel, List<? extends Number> values) {
        MathContext mathContext = supportVectorMachineModel.getMathContext();
        switch (mathContext) {
            case FLOAT: {
                return Floats.toArray(values);
            }
            case DOUBLE: {
                return Doubles.toArray(values);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)supportVectorMachineModel, (Enum<?>)mathContext);
    }
}

