/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.PMMLAttributes;
import org.dmg.pmml.scorecard.PMMLElements;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Functions;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VoteAggregator;
import org.jpmml.evaluator.scorecard.ReasonCodeRanking;

public class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    public ScorecardEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, Scorecard.class));
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
        Characteristics characteristics = scorecard.getCharacteristics();
        if (characteristics == null) {
            throw new MissingElementException((PMMLObject)scorecard, PMMLElements.SCORECARD_CHARACTERISTICS);
        }
        if (!characteristics.hasCharacteristics()) {
            throw new MissingElementException((PMMLObject)characteristics, PMMLElements.CHARACTERISTICS_CHARACTERISTICS);
        }
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    @Override
    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        Scorecard scorecard = (Scorecard)this.getModel();
        boolean useReasonCodes = scorecard.isUseReasonCodes();
        TargetField targetField = this.getTargetField();
        Value<V> score = valueFactory.newValue(scorecard.getInitialScore());
        VoteAggregator<String, V> reasonCodePoints = null;
        if (useReasonCodes) {
            reasonCodePoints = new VoteAggregator<String, V>(valueFactory);
        }
        Characteristics characteristics = scorecard.getCharacteristics();
        for (Characteristic characteristic : characteristics) {
            Number baselineScore = null;
            if (useReasonCodes) {
                baselineScore = characteristic.getBaselineScore();
                if (baselineScore == null) {
                    baselineScore = scorecard.getBaselineScore();
                }
                if (baselineScore == null) {
                    throw new MissingAttributeException((PMMLObject)characteristic, PMMLAttributes.CHARACTERISTIC_BASELINESCORE);
                }
            }
            Number partialScore = null;
            List attributes = characteristic.getAttributes();
            for (Attribute attribute : attributes) {
                Number difference;
                Boolean status = PredicateUtil.evaluatePredicateContainer(attribute, context);
                if (status == null || !status.booleanValue()) continue;
                ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
                if (complexPartialScore != null) {
                    FieldValue computedValue = ExpressionUtil.evaluateExpressionContainer(complexPartialScore, context);
                    if (FieldValueUtil.isMissing(computedValue)) {
                        return TargetUtil.evaluateRegressionDefault(valueFactory, targetField);
                    }
                    partialScore = computedValue.asNumber();
                } else {
                    partialScore = attribute.getPartialScore();
                    if (partialScore == null) {
                        throw new MissingAttributeException((PMMLObject)attribute, PMMLAttributes.ATTRIBUTE_PARTIALSCORE);
                    }
                }
                score.add(partialScore);
                if (!useReasonCodes) break;
                String reasonCode = attribute.getReasonCode();
                if (reasonCode == null) {
                    reasonCode = characteristic.getReasonCode();
                }
                if (reasonCode == null) {
                    throw new MissingAttributeException((PMMLObject)attribute, PMMLAttributes.ATTRIBUTE_REASONCODE);
                }
                Scorecard.ReasonCodeAlgorithm reasonCodeAlgorithm = scorecard.getReasonCodeAlgorithm();
                switch (reasonCodeAlgorithm) {
                    case POINTS_ABOVE: {
                        difference = Functions.SUBTRACT.evaluate(partialScore, baselineScore);
                        break;
                    }
                    case POINTS_BELOW: {
                        difference = Functions.SUBTRACT.evaluate(baselineScore, partialScore);
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)scorecard, (Enum<?>)reasonCodeAlgorithm);
                    }
                }
                reasonCodePoints.add(reasonCode, difference);
                break;
            }
            if (partialScore != null) continue;
            throw new UndefinedResultException().ensureContext((PMMLObject)characteristic);
        }
        if (useReasonCodes) {
            ReasonCodeRanking<V> result = ScorecardEvaluator.createReasonCodeRanking(targetField, score, reasonCodePoints.sumMap());
            return TargetUtil.evaluateRegression(targetField, result);
        }
        return TargetUtil.evaluateRegression(targetField, score);
    }

    private static <V extends Number> ReasonCodeRanking<V> createReasonCodeRanking(TargetField targetField, Value<V> score, ValueMap<String, V> reasonCodePoints) {
        score = TargetUtil.evaluateRegressionInternal(targetField, score);
        Set entrySet = reasonCodePoints.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Value value = (Value)entry.getValue();
            if (value.compareTo(Numbers.DOUBLE_ZERO) >= 0) continue;
            it.remove();
        }
        return new ReasonCodeRanking<V>(score, reasonCodePoints);
    }
}

