/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionException;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.functions.MissingValueTolerant;

public abstract class AbstractFunction
implements Function {
    private String name = null;
    private List<String> aliases = null;

    public AbstractFunction(String name) {
        this(name, null);
    }

    public AbstractFunction(String name, List<String> aliases) {
        this.setName(Objects.requireNonNull(name));
        this.setAliases(aliases);
    }

    protected void checkFixedArityArguments(List<FieldValue> arguments, int arity) {
        if (arguments.size() != arity) {
            throw new FunctionException(this, "Expected " + arity + " values, got " + arguments.size() + " values");
        }
    }

    protected void checkVariableArityArguments(List<FieldValue> arguments, int minArity) {
        if (arguments.size() < minArity) {
            throw new FunctionException(this, "Expected " + minArity + " or more values, got " + arguments.size() + " values");
        }
    }

    protected void checkVariableArityArguments(List<FieldValue> arguments, int minArity, int maxArity) {
        if (arguments.size() < minArity || arguments.size() > maxArity) {
            throw new FunctionException(this, "Expected " + minArity + " to " + maxArity + " values, got " + arguments.size() + " values");
        }
    }

    protected FieldValue getArgument(List<FieldValue> arguments, int index) {
        if (this instanceof MissingValueTolerant) {
            return this.getOptionalArgument(arguments, index);
        }
        return this.getRequiredArgument(arguments, index);
    }

    protected FieldValue getOptionalArgument(List<FieldValue> arguments, int index) {
        FieldValue argument = arguments.get(index);
        return argument;
    }

    protected FieldValue getRequiredArgument(List<FieldValue> arguments, int index) {
        FieldValue argument = arguments.get(index);
        if (FieldValueUtil.isMissing(argument)) {
            String alias = null;
            List<String> aliases = this.getAliases();
            if (aliases != null && index < aliases.size()) {
                alias = aliases.get(index);
            }
            if (alias != null) {
                throw new FunctionException(this, "Missing " + PMMLException.formatKey(alias) + " value at position " + index);
            }
            throw new FunctionException(this, "Missing value at position " + index);
        }
        return argument;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    private void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }
}

