/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidElementListException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;

public class NormalizationUtil {
    private NormalizationUtil() {
    }

    public static FieldValue normalize(NormContinuous normContinuous, FieldValue value) {
        Number result = NormalizationUtil.normalize(normContinuous, value.asNumber());
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }

    public static Number normalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        if ((doubleValue = NormalizationUtil.normalize(normContinuous, doubleValue)) == null) {
            return null;
        }
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> normalize(NormContinuous normContinuous, Value<V> value) {
        Number startNorm;
        Number endOrig;
        Number startOrig;
        LinearNorm end;
        LinearNorm start;
        block20: {
            List<LinearNorm> linearNorms;
            block19: {
                linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
                start = linearNorms.get(0);
                end = linearNorms.get(linearNorms.size() - 1);
                startOrig = start.getOrig();
                if (startOrig == null) {
                    throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_ORIG);
                }
                endOrig = end.getOrig();
                if (endOrig == null) {
                    throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_ORIG);
                }
                if (value.compareTo(startOrig) >= 0 && value.compareTo(endOrig) <= 0) break block19;
                OutlierTreatmentMethod outlierTreatmentMethod = normContinuous.getOutliers();
                switch (outlierTreatmentMethod) {
                    case AS_IS: {
                        if (value.compareTo(startOrig) < 0) {
                            end = linearNorms.get(1);
                            endOrig = end.getOrig();
                            if (endOrig == null) {
                                throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_ORIG);
                            }
                        } else {
                            start = linearNorms.get(linearNorms.size() - 2);
                            startOrig = start.getOrig();
                            if (startOrig == null) {
                                throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_ORIG);
                            }
                        }
                        break block20;
                    }
                    case AS_MISSING_VALUES: {
                        return null;
                    }
                    case AS_EXTREME_VALUES: {
                        if (value.compareTo(startOrig) < 0) {
                            Number startNorm2 = start.getNorm();
                            if (startNorm2 == null) {
                                throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_NORM);
                            }
                            return value.restrict(startNorm2, Double.POSITIVE_INFINITY);
                        }
                        Number endNorm = end.getNorm();
                        if (endNorm == null) {
                            throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_NORM);
                        }
                        return value.restrict(Double.NEGATIVE_INFINITY, endNorm);
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)normContinuous, (Enum<?>)outlierTreatmentMethod);
                    }
                }
            }
            int max = linearNorms.size() - 1;
            for (int i = 1; i < max; ++i) {
                LinearNorm linearNorm = linearNorms.get(i);
                Number orig = linearNorm.getOrig();
                if (orig == null) {
                    throw new MissingAttributeException((PMMLObject)linearNorm, PMMLAttributes.LINEARNORM_ORIG);
                }
                if (value.compareTo(orig) >= 0) {
                    start = linearNorm;
                    startOrig = orig;
                    continue;
                }
                if (value.compareTo(orig) > 0) continue;
                end = linearNorm;
                endOrig = orig;
                break;
            }
        }
        if ((startNorm = start.getNorm()) == null) {
            throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_NORM);
        }
        Number endNorm = end.getNorm();
        if (endNorm == null) {
            throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_NORM);
        }
        return value.normalize(startOrig, startNorm, endOrig, endNorm);
    }

    public static Number denormalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        doubleValue = NormalizationUtil.denormalize(normContinuous, doubleValue);
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> denormalize(NormContinuous normContinuous, Value<V> value) {
        Number startOrig;
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        LinearNorm start = linearNorms.get(0);
        LinearNorm end = linearNorms.get(linearNorms.size() - 1);
        Number startNorm = start.getNorm();
        if (startNorm == null) {
            throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_NORM);
        }
        Number endNorm = end.getNorm();
        if (endNorm == null) {
            throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_NORM);
        }
        int max = linearNorms.size() - 1;
        for (int i = 1; i < max; ++i) {
            LinearNorm linearNorm = linearNorms.get(i);
            Number norm = linearNorm.getNorm();
            if (norm == null) {
                throw new MissingAttributeException((PMMLObject)linearNorm, PMMLAttributes.LINEARNORM_NORM);
            }
            if (value.compareTo(norm) >= 0) {
                start = linearNorm;
                startNorm = norm;
                continue;
            }
            if (value.compareTo(norm) > 0) continue;
            end = linearNorm;
            endNorm = norm;
            break;
        }
        if ((startOrig = start.getOrig()) == null) {
            throw new MissingAttributeException((PMMLObject)start, PMMLAttributes.LINEARNORM_ORIG);
        }
        Number endOrig = end.getOrig();
        if (endOrig == null) {
            throw new MissingAttributeException((PMMLObject)end, PMMLAttributes.LINEARNORM_ORIG);
        }
        return value.denormalize(startOrig, startNorm, endOrig, endNorm);
    }

    private static List<LinearNorm> ensureLinearNorms(NormContinuous normContinuous) {
        if (!normContinuous.hasLinearNorms()) {
            throw new MissingElementException((PMMLObject)normContinuous, PMMLElements.NORMCONTINUOUS_LINEARNORMS);
        }
        List linearNorms = normContinuous.getLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidElementListException(linearNorms);
        }
        return linearNorms;
    }
}

